/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.environment.tilemap.ILayerList;
import de.gurkenlabs.litiengine.environment.tilemap.IMapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.ITilesetEntry;
import de.gurkenlabs.litiengine.environment.tilemap.RenderOrder;
import de.gurkenlabs.litiengine.environment.tilemap.StaggerAxis;
import de.gurkenlabs.litiengine.environment.tilemap.StaggerIndex;
import de.gurkenlabs.litiengine.util.AlphanumComparator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.List;

public interface IMap
extends ILayerList,
Comparable<IMap> {
    public List<ITileset> getTilesets();

    public ITilesetEntry getTilesetEntry(int var1);

    public IMapOrientation getOrientation();

    public URL getPath();

    public RenderOrder getRenderOrder();

    public Dimension getSizeInPixels();

    public int getWidth();

    public int getHeight();

    public Dimension getSizeInTiles();

    public Rectangle2D getBounds();

    public Dimension getTileSize();

    public int getTileWidth();

    public int getTileHeight();

    public int getHexSideLength();

    public StaggerAxis getStaggerAxis();

    public StaggerIndex getStaggerIndex();

    public double getVersion();

    public String getTiledVersion();

    public String getName();

    public void setName(String var1);

    public int getNextObjectId();

    public int getNextLayerId();

    public Color getBackgroundColor();

    public boolean isInfinite();

    @Override
    default public int compareTo(IMap map) {
        return AlphanumComparator.compareTo(this.getName(), map.getName());
    }
}

