/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.SoundSource;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.ArrayList;
import java.util.Collection;

public class SoundSourceMapObjectLoader
extends MapObjectLoader {
    protected SoundSourceMapObjectLoader() {
        super(MapObjectType.SOUNDSOURCE);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        SoundSource sound = this.createSoundSource(mapObject);
        SoundSourceMapObjectLoader.loadDefaultProperties(sound, mapObject);
        entities.add(sound);
        return entities;
    }

    protected SoundSource createSoundSource(IMapObject mapObject) {
        SoundSource sound = new SoundSource();
        sound.setSound(mapObject.getStringValue("soundName"));
        sound.setVolume(mapObject.getFloatValue("soundVolume"));
        sound.setLoop(mapObject.getBoolValue("soundLoop"));
        sound.setRange(mapObject.getIntValue("soundRange"));
        return sound;
    }
}

