/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.entities.IEntityController;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class EntityControllers {
    private Map<Class<? extends IEntityController>, IEntityController> controllers = new ConcurrentHashMap<Class<? extends IEntityController>, IEntityController>();
    private IEntityAnimationController animationController;

    EntityControllers() {
    }

    public IEntityAnimationController getAnimationController() {
        if (this.animationController == null) {
            this.animationController = this.getController(IEntityAnimationController.class);
        }
        return this.animationController;
    }

    public <T extends IEntityController> T getController(Class<T> clss) {
        T explicitController = this.getExplicitController(clss);
        if (explicitController != null) {
            return explicitController;
        }
        for (IEntityController controller : this.controllers.values()) {
            if (!clss.isInstance(controller)) continue;
            return (T)controller;
        }
        return null;
    }

    public <T extends IEntityController> void clearControllers(Class<T> clss) {
        Optional<Class> typeKey = this.controllers.keySet().stream().filter(x -> clss.isAssignableFrom((Class<?>)x)).findFirst();
        if (typeKey.isPresent()) {
            IEntityController controller = this.controllers.get(typeKey.get());
            controller.detach();
            this.controllers.remove(typeKey.get());
            this.animationController = null;
        }
    }

    public <T extends IEntityController> void addController(T controller) {
        this.controllers.put(controller.getClass(), controller);
        if (controller.getEntity().isLoaded()) {
            controller.attach();
        }
        this.animationController = null;
    }

    public <T extends IEntityController> void setController(Class<T> clss, T controller) {
        this.clearControllers(clss);
        this.addController(controller);
        this.animationController = null;
    }

    public void detachAll() {
        for (IEntityController controller : this.controllers.values()) {
            controller.detach();
        }
    }

    public void attachAll() {
        for (IEntityController controller : this.controllers.values()) {
            controller.attach();
        }
    }

    private <T extends IEntityController> T getExplicitController(Class<T> clss) {
        IEntityController controller;
        if (this.controllers.containsKey(clss) && (controller = this.controllers.get(clss)) != null && clss.isInstance(controller)) {
            return (T)this.controllers.get(clss);
        }
        return null;
    }
}

