/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public final class GameRandom
extends Random {
    private static final String INVALID_BOUNDS_ERROR = "min value is > than max value";
    private static final String ARRAY_MUST_NOT_BE_EMPTY = "array to chose an element from must not be null or empty.";
    private static final String INVALID_AMOUNT_FOR_SAMPLING_WITHOUT_REPLACEMENT = "amount must be <= the specified array length for sampling without replacement.";

    GameRandom() {
    }

    public void setSeed(String seed) {
        this.setSeed(seed.hashCode());
    }

    public <T> T[] sample(T[] array, int amount, boolean replacement) {
        if (!replacement && array.length < amount) {
            throw new IllegalArgumentException(INVALID_AMOUNT_FOR_SAMPLING_WITHOUT_REPLACEMENT);
        }
        Object[] sampled = (Object[])Array.newInstance(array.getClass().getComponentType(), amount);
        if (!replacement) {
            T[] copiedArray = ArrayUtilities.arrayCopy(array);
            this.shuffle(copiedArray);
            System.arraycopy(copiedArray, 0, sampled, 0, amount);
            return sampled;
        }
        for (int i = 0; i < amount; ++i) {
            sampled[i] = this.choose(array);
        }
        return sampled;
    }

    public <T> Collection<T> sample(Collection<T> collection, int amount, boolean replacement) {
        if (!replacement && collection.size() < amount) {
            throw new IllegalArgumentException(INVALID_AMOUNT_FOR_SAMPLING_WITHOUT_REPLACEMENT);
        }
        if (!replacement) {
            ArrayList<T> copied = new ArrayList<T>(collection);
            this.shuffle(copied);
            return copied.stream().limit(amount).collect(Collectors.toList());
        }
        ArrayList<T> copied = new ArrayList<T>(amount);
        for (int i = 0; i < amount; ++i) {
            copied.add(this.choose(collection));
        }
        return copied;
    }

    public <T> T choose(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[this.nextInt(array.length)];
    }

    public int choose(int ... array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(ARRAY_MUST_NOT_BE_EMPTY);
        }
        return array[this.nextInt(array.length)];
    }

    public long choose(long ... array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(ARRAY_MUST_NOT_BE_EMPTY);
        }
        return array[this.nextInt(array.length)];
    }

    public double choose(double ... array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(ARRAY_MUST_NOT_BE_EMPTY);
        }
        return array[this.nextInt(array.length)];
    }

    public String choose(String ... array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(ARRAY_MUST_NOT_BE_EMPTY);
        }
        return array[this.nextInt(array.length)];
    }

    public <T> T choose(Collection<T> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        int num = this.nextInt(coll.size());
        for (T t : coll) {
            if (--num >= 0) continue;
            return t;
        }
        return null;
    }

    public <T> void shuffle(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            int randomPosition = this.nextInt(array.length);
            T temp = array[i];
            array[i] = array[randomPosition];
            array[randomPosition] = temp;
        }
    }

    public void shuffle(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            int randomPosition = this.nextInt(array.length);
            int temp = array[i];
            array[i] = array[randomPosition];
            array[randomPosition] = temp;
        }
    }

    public void shuffle(long[] array) {
        for (int i = 0; i < array.length; ++i) {
            int randomPosition = this.nextInt(array.length);
            long temp = array[i];
            array[i] = array[randomPosition];
            array[randomPosition] = temp;
        }
    }

    public void shuffle(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            int randomPosition = this.nextInt(array.length);
            double temp = array[i];
            array[i] = array[randomPosition];
            array[randomPosition] = temp;
        }
    }

    public <T> void shuffle(List<T> coll) {
        Collections.shuffle(coll, this);
    }

    public int nextSign() {
        return this.nextBoolean() ? 1 : -1;
    }

    public int shuffleSign(int value) {
        return value * this.nextSign();
    }

    public float shuffleSign(float value) {
        return value * (float)this.nextSign();
    }

    public long shuffleSign(long value) {
        return value * (long)this.nextSign();
    }

    public double shuffleSign(double value) {
        return value * (double)this.nextSign();
    }

    @Override
    public long nextLong(long bound) {
        return this.nextLong(0L, bound);
    }

    @Override
    public long nextLong(long min, long bound) {
        if (min == bound) {
            return min;
        }
        if (min > bound) {
            throw new IllegalArgumentException(INVALID_BOUNDS_ERROR);
        }
        return min + this.nextLong() * (bound - min);
    }

    @Override
    public double nextDouble(double bound) {
        return this.nextDouble(0.0, bound);
    }

    @Override
    public double nextDouble(double min, double bound) {
        if (min == bound) {
            return min;
        }
        if (min > bound) {
            throw new IllegalArgumentException(INVALID_BOUNDS_ERROR);
        }
        return min + this.nextDouble() * (bound - min);
    }

    @Override
    public float nextFloat(float bound) {
        return this.nextFloat(0.0f, bound);
    }

    @Override
    public float nextFloat(float min, float bound) {
        if (min == bound) {
            return min;
        }
        if (min > bound) {
            throw new IllegalArgumentException(INVALID_BOUNDS_ERROR);
        }
        return min + this.nextFloat() * (bound - min);
    }

    @Override
    public int nextInt(int min, int bound) {
        if (min == bound) {
            return min;
        }
        if (min > bound) {
            throw new IllegalArgumentException(INVALID_BOUNDS_ERROR);
        }
        return this.nextInt(bound - min) + min;
    }

    public <T extends Enum<?>> T next(Class<T> clazz) {
        int x = this.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    public boolean probe(double probability) {
        double rnd = this.nextDouble();
        return rnd <= probability;
    }

    public int getIndex(double[] indexProbabilities) {
        double rnd = this.nextDouble();
        double probSum = 0.0;
        for (int i = 0; i < indexProbabilities.length; ++i) {
            double newProbSum = probSum + indexProbabilities[i];
            if (rnd >= probSum && rnd < newProbSum) {
                return i;
            }
            probSum = newProbSum;
        }
        return 0;
    }

    public Point2D getLocation(double x, double y, double width, double height) {
        double xOffset = this.nextDouble(width);
        double yOffset = this.nextDouble(height);
        return new Point2D.Double(x + xOffset, y + yOffset);
    }

    public Point2D getLocation(Rectangle2D rect) {
        return this.getLocation(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public Point2D getLocation(IEntity entity) {
        return this.getLocation(entity.getBoundingBox());
    }

    public Point2D getLocation(IMap map) {
        return this.getLocation(map.getBounds());
    }

    public Point2D getLocation(Ellipse2D circle) {
        double radius = circle.getWidth() / 2.0;
        double a = Math.random() * 2.0 * Math.PI;
        double r = radius * Math.sqrt(Math.random());
        double x = r * Math.cos(a) + radius;
        double y = r * Math.sin(a) + radius;
        return new Point2D.Double(circle.getX() + x, circle.getY() + y);
    }

    public Point2D getLocation(Line2D line) {
        return this.getLocation(line.getP1(), line.getP2());
    }

    public Point2D getLocation(Point2D start, Point2D end) {
        double rnd = this.nextDouble(start.distance(end));
        return GeometricUtilities.project(start, end, rnd);
    }

    public char nextChar() {
        int start = 0;
        int end = 65535;
        return (char)((double)start + this.nextDouble() * (double)(end - start + 1));
    }

    public char nextChar(String alphabet) {
        return alphabet.charAt(this.nextInt(alphabet.length()));
    }

    public char nextAscii() {
        return (char)(32.0 + this.nextDouble() * 95.0);
    }

    public String nextAscii(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(this.nextAscii());
        }
        return sb.toString();
    }

    public String nextAlphanumeric(int length) {
        return this.nextAlphanumeric(length, false);
    }

    public String nextAlphanumeric(int length, boolean lowerCase) {
        return this.nextAlphanumeric(length, true, lowerCase);
    }

    public String nextAlphanumeric(int length, boolean digit, boolean lowerCase) {
        String digits = "0123456789";
        String upperLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Object alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (lowerCase) {
            alphabet = (String)alphabet + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase();
        }
        if (digit) {
            alphabet = (String)alphabet + "0123456789";
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(this.nextChar((String)alphabet));
        }
        return sb.toString();
    }

    public String nextAlphabetic(int length) {
        return this.nextAlphanumeric(length, false, false);
    }

    public String nextAlphabetic(int length, boolean lowerCase) {
        return this.nextAlphanumeric(length, false, lowerCase);
    }

    public Color nextColor(Color originalColor, float colorVariance, float alphaVariance) {
        if (originalColor == null) {
            return null;
        }
        int red = MathUtilities.clamp((int)((float)originalColor.getRed() + (float)originalColor.getRed() * this.nextFloat(colorVariance) * (float)this.nextSign()), 0, 255);
        int green = MathUtilities.clamp((int)((float)originalColor.getGreen() + (float)originalColor.getGreen() * this.nextFloat(colorVariance) * (float)this.nextSign()), 0, 255);
        int blue = MathUtilities.clamp((int)((float)originalColor.getBlue() + (float)originalColor.getBlue() * this.nextFloat(colorVariance) * (float)this.nextSign()), 0, 255);
        int alpha = MathUtilities.clamp((int)((float)originalColor.getAlpha() + (float)originalColor.getAlpha() * this.nextFloat(alphaVariance) * (float)this.nextSign()), 0, 255);
        return new Color(red, green, blue, alpha);
    }
}

