/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class URLAdapter
extends XmlAdapter<String, URL> {
    private URL base;

    public URLAdapter() {
        this(null);
    }

    public URLAdapter(URL base) {
        this.base = base;
    }

    public URL unmarshal(String v) throws MalformedURLException {
        if (v == null) {
            return null;
        }
        if (this.base != null) {
            return new URL(this.base, v);
        }
        return new URL(v);
    }

    public String marshal(URL v) {
        int i;
        int firstDiff;
        if (v == null) {
            return null;
        }
        if (this.base == null || !this.base.getProtocol().equals(v.getProtocol()) || !Objects.equals(this.base.getAuthority(), v.getAuthority())) {
            return v.toExternalForm();
        }
        if (this.base.equals(v)) {
            return "#";
        }
        if (this.base.getFile().equals(v.getFile())) {
            return "#" + v.getRef();
        }
        String[] path1 = v.getFile().split("/");
        String[] path2 = this.base.getFile().split("/");
        for (firstDiff = 0; firstDiff < path1.length && firstDiff < path2.length && path1[firstDiff].equals(path2[firstDiff]); ++firstDiff) {
        }
        if (firstDiff == 0) {
            return v.getFile();
        }
        StringBuilder builder = new StringBuilder();
        for (i = path2.length - 1; i > firstDiff; --i) {
            builder.append("/..");
        }
        for (i = firstDiff; i < path1.length; ++i) {
            builder.append('/');
            builder.append(path1[i]);
        }
        return builder.substring(1);
    }

    public URL getBaseURL() {
        return this.base;
    }
}

