/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.HorizontalSlider;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.VerticalSlider;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntConsumer;

public class ListField
extends GuiComponent {
    private final List<IntConsumer> changeConsumer = new CopyOnWriteArrayList<IntConsumer>();
    private final CopyOnWriteArrayList<CopyOnWriteArrayList<ImageComponent>> listEntries;
    private final Object[][] content;
    private final int shownRows;
    private final int shownColumns;
    private final int nbOfColumns;
    private boolean arrowKeyNavigation;
    private Spritesheet buttonSprite;
    private Spritesheet entrySprite;
    private int verticalLowerBound = 0;
    private int horizontalLowerBound = 0;
    private ImageComponent selectedComponent;
    private int selectionColumn = -1;
    private int selectionRow = -1;
    private boolean selectEntireColumn = false;
    private boolean selectEntireRow = false;
    private VerticalSlider verticalSlider;
    private HorizontalSlider horizontalSlider;
    private boolean sliderInside = false;

    public ListField(double x, double y, double width, double height, Object[] content, int shownRows) {
        this(x, y, width, height, new Object[][]{content}, shownRows, 1);
    }

    public ListField(double x, double y, double width, double height, Object[][] content, int shownRows, int shownColumns) {
        super(x, y, width, height);
        this.content = content;
        this.nbOfColumns = this.content.length;
        this.listEntries = new CopyOnWriteArrayList();
        this.shownRows = shownRows;
        this.shownColumns = shownColumns;
        this.initSliders();
        this.initContentList();
        this.prepareInput();
    }

    public void deselect() {
        this.selectionColumn = -1;
        this.selectionRow = -1;
        this.selectedComponent = null;
    }

    public Spritesheet getButtonSprite() {
        return this.buttonSprite;
    }

    public void setButtonSprite(Spritesheet buttonSprite) {
        this.buttonSprite = buttonSprite;
        this.initContentList();
    }

    public List<IntConsumer> getChangeConsumer() {
        return this.changeConsumer;
    }

    public Object[][] getContent() {
        return this.content;
    }

    public Spritesheet getEntrySprite() {
        return this.entrySprite;
    }

    public void setEntrySprite(Spritesheet entrySprite) {
        this.entrySprite = entrySprite;
        this.initContentList();
    }

    public int getHorizontalLowerBound() {
        return this.horizontalLowerBound;
    }

    public void setHorizontalLowerBound(int lowerBound) {
        this.horizontalLowerBound = lowerBound;
    }

    public HorizontalSlider getHorizontalSlider() {
        return this.horizontalSlider;
    }

    public List<ImageComponent> getListEntry(int column) {
        if (column < 0 || column >= this.listEntries.size()) {
            return new ArrayList<ImageComponent>();
        }
        return this.listEntries.get(column);
    }

    public ImageComponent getListEntry(int column, int row) {
        if (column < 0 || row < 0 || column >= this.listEntries.size() || row >= this.listEntries.get(column).size()) {
            return null;
        }
        return this.listEntries.get(column).get(row);
    }

    public int getMaxRows() {
        int result = 0;
        for (Object[] o : this.getContent()) {
            if (o.length <= result) continue;
            result = o.length;
        }
        return result;
    }

    public int getNumberOfShownRows() {
        return this.shownRows;
    }

    public int getNumberOfShownColumns() {
        return this.shownColumns;
    }

    public ImageComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Object getSelectedObject() {
        if (this.getSelectedComponent() == null) {
            return null;
        }
        return this.getContent()[this.selectionColumn][this.selectionRow];
    }

    public int getSelectionColumn() {
        if (this.isEntireRowSelected()) {
            return -1;
        }
        return this.selectionColumn;
    }

    public int getSelectionRow() {
        return this.selectionRow;
    }

    public int getVerticalLowerBound() {
        return this.verticalLowerBound;
    }

    public void setVerticalLowerBound(int lowerBound) {
        this.verticalLowerBound = lowerBound;
    }

    public VerticalSlider getVerticalSlider() {
        return this.verticalSlider;
    }

    public boolean isArrowKeyNavigation() {
        return this.arrowKeyNavigation;
    }

    public void setArrowKeyNavigation(boolean arrowKeyNavigation) {
        this.arrowKeyNavigation = arrowKeyNavigation;
    }

    public void onChange(IntConsumer c) {
        this.getChangeConsumer().add(c);
    }

    public void refresh() {
        this.refreshListEntries();
        this.selectComponent();
    }

    @Override
    public void render(Graphics2D g) {
        super.render(g);
        if (this.selectedComponent != null) {
            double borderWidth = this.selectedComponent.getWidth() + 2.0;
            double borderHeight = this.selectedComponent.getHeight() + 2.0;
            if (this.isEntireRowSelected()) {
                borderWidth = this.getWidth() + 2.0;
            }
            if (this.getVerticalSlider() != null && this.getVerticalSlider().isVisible() && this.isSliderInside()) {
                borderWidth -= this.getVerticalSlider().getWidth();
            }
            if (this.isEntireColumnSelected()) {
                borderHeight = this.getHeight() + 2.0;
            }
            Rectangle2D.Double border = new Rectangle2D.Double(this.selectedComponent.getX() - 1.0, this.selectedComponent.getY() - 1.0, borderWidth, borderHeight);
            g.setColor(Color.WHITE);
            ShapeRenderer.renderOutline(g, (Shape)border, 2.0f);
        }
    }

    public void setForwardMouseEvents(int column, boolean forwardMouseEvents) {
        if (column < 0 && column >= this.nbOfColumns) {
            return;
        }
        for (ImageComponent comp : this.getListEntry(column)) {
            comp.setForwardMouseEvents(forwardMouseEvents);
        }
    }

    public void setSelection(int column, int row) {
        if (column < 0 || column >= this.nbOfColumns || row < 0 || row >= this.getContent()[column].length) {
            return;
        }
        this.selectionColumn = column;
        this.selectionRow = row;
        if (this.selectionRow >= this.getVerticalLowerBound() + this.getNumberOfShownRows()) {
            this.setVerticalLowerBound(this.getVerticalLowerBound() + 1);
        } else if (this.selectionRow < this.getVerticalLowerBound() && this.getVerticalLowerBound() > 0) {
            this.setVerticalLowerBound(this.getVerticalLowerBound() - 1);
        }
        if (this.selectionColumn >= this.getHorizontalLowerBound() + this.getNumberOfShownColumns()) {
            this.setHorizontalLowerBound(this.getHorizontalLowerBound() + 1);
        } else if (this.selectionColumn < this.getHorizontalLowerBound() && this.getHorizontalLowerBound() > 0) {
            this.setHorizontalLowerBound(this.getHorizontalLowerBound() - 1);
        }
        this.getChangeConsumer().forEach(consumer -> consumer.accept(this.selectionRow));
        this.refresh();
    }

    public void setSelectEntireColumn(boolean selectEntireColumn) {
        this.selectEntireColumn = selectEntireColumn;
    }

    public void setSelectEntireRow(boolean selectEntireRow) {
        this.selectEntireRow = selectEntireRow;
    }

    public boolean isEntireColumnSelected() {
        return this.selectEntireColumn;
    }

    public boolean isEntireRowSelected() {
        return this.selectEntireRow;
    }

    public boolean isSliderInside() {
        return this.sliderInside;
    }

    public void setSliderInside(boolean sliderInside) {
        this.sliderInside = sliderInside;
        this.initSliders();
    }

    public void slideUp() {
        if (this.getVerticalLowerBound() <= 0) {
            return;
        }
        this.setVerticalLowerBound(this.getVerticalLowerBound() - 1);
        this.refresh();
    }

    public void slideDown() {
        if (this.getVerticalLowerBound() >= this.getMaxRows() - this.getNumberOfShownRows()) {
            return;
        }
        this.setVerticalLowerBound(this.getVerticalLowerBound() + 1);
        this.refresh();
    }

    private boolean canHandleKeyboardEvent() {
        return !this.isSuspended() && this.isVisible() && this.isArrowKeyNavigation();
    }

    private void prepareInput() {
        Input.keyboard().onKeyTyped(38, e -> {
            if (!this.canHandleKeyboardEvent()) {
                return;
            }
            this.setSelection(this.getHorizontalLowerBound(), this.selectionRow - 1);
        });
        Input.keyboard().onKeyTyped(40, e -> {
            if (!this.canHandleKeyboardEvent()) {
                return;
            }
            this.setSelection(this.getHorizontalLowerBound(), this.selectionRow + 1);
        });
        Input.keyboard().onKeyTyped(37, e -> {
            if (!this.canHandleKeyboardEvent()) {
                return;
            }
            this.setSelection(this.getHorizontalLowerBound() - 1, this.selectionRow);
        });
        Input.keyboard().onKeyTyped(39, e -> {
            if (!this.canHandleKeyboardEvent()) {
                return;
            }
            this.setSelection(this.getHorizontalLowerBound() + 1, this.selectionRow);
        });
        this.onMouseWheelScrolled(e -> {
            if (this.isSuspended() || !this.isVisible()) {
                return;
            }
            if (this.isHovered()) {
                if (e.getEvent().getWheelRotation() < 0) {
                    this.slideUp();
                } else {
                    this.slideDown();
                }
            }
        });
    }

    private void initContentList() {
        double columnWidth = this.getWidth() / (double)this.getNumberOfShownColumns();
        double rowHeight = this.getHeight() / (double)this.getNumberOfShownRows();
        for (int column = 0; column < this.getNumberOfShownColumns(); ++column) {
            this.listEntries.add(new CopyOnWriteArrayList());
            for (int row = 0; row < this.getNumberOfShownRows(); ++row) {
                ImageComponent entryComponent;
                if (this.getContent()[column].length <= row) continue;
                if (this.getContent()[column][row] == null) {
                    entryComponent = new ImageComponent(this.getX() + columnWidth * (double)column, this.getY() + rowHeight * (double)row, columnWidth, rowHeight, this.entrySprite, "", null);
                } else {
                    Object object = this.getContent()[column][row];
                    if (object instanceof Image) {
                        Image image = (Image)object;
                        entryComponent = new ImageComponent(this.getX() + columnWidth * (double)column, this.getY() + rowHeight * (double)row, columnWidth, rowHeight, this.entrySprite, "", image);
                    } else {
                        entryComponent = new ImageComponent(this.getX() + columnWidth * (double)column, this.getY() + rowHeight * (double)row, columnWidth, rowHeight, this.entrySprite, this.getContent()[column][row].toString(), null);
                    }
                }
                if (this.isSliderInside() && this.getVerticalSlider() != null) {
                    entryComponent.setX(this.getX() + (columnWidth - this.getVerticalSlider().getWidth() / (double)this.getNumberOfShownColumns()) * (double)column);
                    entryComponent.setWidth(entryComponent.getWidth() - this.getVerticalSlider().getWidth() / (double)this.getNumberOfShownColumns());
                }
                if (this.isSliderInside() && this.getHorizontalSlider() != null) {
                    entryComponent.setY(this.getY() + (rowHeight - this.getHorizontalSlider().getHeight() / (double)this.getNumberOfShownRows()) * (double)row);
                    entryComponent.setHeight(entryComponent.getHeight() - this.getHorizontalSlider().getHeight() / (double)this.getNumberOfShownRows());
                }
                entryComponent.setTextAlign(Align.LEFT);
                this.getListEntry(column).add(entryComponent);
            }
            this.getComponents().addAll(this.getListEntry(column));
            int col = column;
            for (ImageComponent comp : this.getListEntry(col)) {
                comp.onClicked(e -> {
                    this.setSelection(this.getHorizontalLowerBound() + col % this.getNumberOfShownColumns(), this.getVerticalLowerBound() + this.getListEntry(col).indexOf(comp) % this.getNumberOfShownRows());
                    this.refresh();
                });
            }
        }
        this.onChange(s -> {
            if (this.getVerticalSlider() != null) {
                this.getVerticalSlider().setCurrentValue(this.getVerticalLowerBound());
                this.getVerticalSlider().getSliderComponent().setLocation(this.getVerticalSlider().getRelativeSliderLocation());
            }
            if (this.getHorizontalSlider() != null) {
                this.getHorizontalSlider().setCurrentValue(this.getHorizontalLowerBound());
                this.getHorizontalSlider().getSliderComponent().setLocation(this.getHorizontalSlider().getRelativeSliderLocation());
            }
        });
        if (this.getVerticalSlider() != null) {
            this.getVerticalSlider().onChange((Float sliderValue) -> {
                this.setVerticalLowerBound(sliderValue.intValue());
                this.getVerticalSlider().getSliderComponent().setLocation(this.getVerticalSlider().getRelativeSliderLocation());
                this.refresh();
            });
        }
        if (this.getHorizontalSlider() != null) {
            this.getHorizontalSlider().onChange((Float sliderValue) -> {
                this.setHorizontalLowerBound(sliderValue.intValue());
                this.getHorizontalSlider().getSliderComponent().setLocation(this.getHorizontalSlider().getRelativeSliderLocation());
                this.refresh();
            });
        }
    }

    private void initSliders() {
        double sliderSize = this.getHeight() / 5.0;
        int maxNbOfRows = this.getMaxRows() - this.getNumberOfShownRows();
        if (this.getNumberOfShownColumns() < this.getContent().length) {
            this.horizontalSlider = this.isSliderInside() ? new HorizontalSlider(this.getX(), this.getY() + this.getHeight() - sliderSize, this.getWidth() - sliderSize, sliderSize, 0.0f, (float)this.nbOfColumns - (float)this.getNumberOfShownColumns(), 1.0f) : new HorizontalSlider(this.getX(), this.getY() + this.getHeight(), this.getWidth(), sliderSize, 0.0f, (float)this.nbOfColumns - (float)this.getNumberOfShownColumns(), 1.0f);
            this.getHorizontalSlider().setCurrentValue(this.getHorizontalLowerBound());
            this.getComponents().add(this.getHorizontalSlider());
        }
        if (maxNbOfRows > 0) {
            this.verticalSlider = this.isSliderInside() ? (this.getHorizontalSlider() != null ? new VerticalSlider(this.getX() + this.getWidth() - sliderSize, this.getY(), sliderSize, this.getHeight() - sliderSize, 0.0f, (float)this.getMaxRows() - (float)this.getNumberOfShownRows(), 1.0f) : new VerticalSlider(this.getX() + this.getWidth() - sliderSize, this.getY(), sliderSize, this.getHeight(), 0.0f, (float)this.getMaxRows() - (float)this.getNumberOfShownRows(), 1.0f)) : new VerticalSlider(this.getX() + this.getWidth(), this.getY(), sliderSize, this.getHeight(), 0.0f, (float)this.getMaxRows() - (float)this.getNumberOfShownRows(), 1.0f);
            this.getVerticalSlider().setCurrentValue(this.getVerticalLowerBound());
            this.getComponents().add(this.getVerticalSlider());
        }
    }

    private void refreshListEntries() {
        for (int column = 0; column < this.getNumberOfShownColumns(); ++column) {
            for (int row = 0; row < this.getNumberOfShownRows(); ++row) {
                if (this.getContent()[column].length <= row) continue;
                if (row + this.getVerticalLowerBound() < this.getContent()[column + this.getHorizontalLowerBound()].length && this.getContent()[column + this.getHorizontalLowerBound()][row + this.getVerticalLowerBound()] != null) {
                    Object object = this.getContent()[column + this.getHorizontalLowerBound()][row + this.getVerticalLowerBound()];
                    if (object instanceof Image) {
                        Image image = (Image)object;
                        this.getListEntry(column, row).setImage(image);
                        continue;
                    }
                    this.getListEntry(column, row).setText(this.getContent()[column + this.getHorizontalLowerBound()][row + this.getVerticalLowerBound()].toString());
                    continue;
                }
                this.getListEntry(column, row).setText("");
            }
        }
    }

    private void selectComponent() {
        this.selectedComponent = !this.isEntireRowSelected() && this.getSelectionColumn() >= this.getHorizontalLowerBound() && this.getSelectionColumn() < this.getHorizontalLowerBound() + this.getNumberOfShownColumns() && this.getSelectionRow() >= this.getVerticalLowerBound() && this.getSelectionRow() < this.getVerticalLowerBound() + this.getNumberOfShownRows() ? this.getListEntry(this.getSelectionColumn() - this.getHorizontalLowerBound(), this.getSelectionRow() - this.getVerticalLowerBound()) : (this.isEntireRowSelected() && this.getSelectionColumn() >= 0 && this.getSelectionColumn() < this.nbOfColumns && this.getSelectionRow() >= this.getVerticalLowerBound() && this.getSelectionRow() < this.getVerticalLowerBound() + this.getNumberOfShownRows() ? this.getListEntry(0, this.getSelectionRow() - this.getVerticalLowerBound()) : null);
        if (this.selectedComponent != null) {
            this.selectedComponent.setSelected(true);
        }
    }
}

