/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.gui.FontIcon;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.Slider;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class HorizontalSlider
extends Slider {
    public static final FontIcon ARROW_LEFT = new FontIcon(ICON_FONT, "\ue805");
    public static final FontIcon ARROW_RIGHT = new FontIcon(ICON_FONT, "\ue806");

    public HorizontalSlider(double x, double y, double width, double height, float minValue, float maxValue, float stepSize) {
        super(x, y, width, height, minValue, maxValue, stepSize);
    }

    @Override
    public Point2D getRelativeSliderLocation() {
        try {
            float frac = MathUtilities.clamp((this.getCurrentValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue()), 0.0f, 1.0f);
            int currentStep = (int)(frac * (float)(this.getSteps() - 1));
            return new Point2D.Double(this.getX() + (double)currentStep * this.getSliderComponent().getWidth(), this.getY());
        }
        catch (Exception e) {
            return new Point2D.Double(0.0, 0.0);
        }
    }

    @Override
    protected void updateSliderDimensions() {
        this.getSliderComponent().setWidth(this.getWidth() / (double)this.getSteps());
    }

    @Override
    protected float getRelativeMouseValue() {
        return (float)((Input.mouse().getLocation().getX() - this.getX()) / this.getWidth());
    }

    @Override
    protected void initializeComponents() {
        super.initializeComponents();
        this.setButton1(new ImageComponent(this.getX() - this.getHeight(), this.getY(), this.getHeight(), this.getHeight(), this.getButtonSpritesheet(), ARROW_LEFT.getText(), null));
        this.getButton1().setFont(ARROW_LEFT.getFont());
        this.setButton2(new ImageComponent(this.getX() + this.getWidth(), this.getY(), this.getHeight(), this.getHeight(), this.getButtonSpritesheet(), ARROW_RIGHT.getText(), null));
        this.getButton2().setFont(ARROW_RIGHT.getFont());
        this.setSliderComponent(new ImageComponent(this.getRelativeSliderLocation().getX(), this.getRelativeSliderLocation().getY(), this.getHeight() * 2.0, this.getHeight(), this.getSliderSpritesheet(), "", null));
    }

    @Override
    protected void renderBar(Graphics2D g) {
        ShapeRenderer.renderOutline(g, (Shape)new Line2D.Double(this.getX(), this.getY() + this.getHeight() / 2.0, this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0), (float)(this.getHeight() / 10.0) * this.getTickSize());
    }

    @Override
    protected void renderTicks(Graphics2D g) {
        for (int i = 1; i < this.getSteps(); ++i) {
            ShapeRenderer.renderOutline(g, (Shape)new Line2D.Double(this.getX() + (double)i * this.getWidth() / (double)this.getSteps(), this.getY() + this.getHeight() / 2.0 - (double)this.getTickSize() * this.getHeight() / 2.0, this.getX() + (double)i * this.getWidth() / (double)this.getSteps(), this.getY() + this.getHeight() / 2.0 + (double)this.getTickSize() * this.getHeight() / 2.0), (float)(this.getWidth() / 200.0 * (double)this.getTickSize()));
        }
    }
}

