/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.emitters.particles.LineParticle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class ShapeParticle
extends Particle {
    public ShapeParticle(float width, float height) {
        super(width, height);
    }

    protected abstract Shape getShape(Point2D var1);

    @Override
    public Rectangle2D getBoundingBox(Point2D origin) {
        return this.getShape(origin).getBounds2D();
    }

    @Override
    public void render(Graphics2D g, Point2D emitterOrigin) {
        g.setColor(new Color((float)this.getColor().getRed() / 255.0f, (float)this.getColor().getGreen() / 255.0f, (float)this.getColor().getBlue() / 255.0f, this.getOpacity()));
        if (this.isOutlineOnly() || this instanceof LineParticle) {
            Game.graphics().renderOutline(g, this.getShape(emitterOrigin), new BasicStroke(1.0f / Game.graphics().getBaseRenderScale()), this.isAntiAliased());
        } else {
            Game.graphics().renderShape(g, this.getShape(emitterOrigin), this.isAntiAliased());
        }
    }
}

