/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.AnimationInfo;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.graphics.CreatureAnimationState;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import java.util.Optional;

public class CreatureAnimationController<T extends Creature>
extends EntityAnimationController<T> {
    private String[] customDeathAnimations;
    private String randomDeathSprite;

    public CreatureAnimationController(T creature, boolean useFlippedSpritesAsFallback) {
        super(creature);
        this.init(useFlippedSpritesAsFallback);
    }

    public CreatureAnimationController(T creature, Animation defaultAnimation) {
        this(creature, true, defaultAnimation, new Animation[0]);
    }

    public CreatureAnimationController(T creature, boolean useFlippedSpritesAsFallback, Animation defaultAnimation, Animation ... animations) {
        super(creature, defaultAnimation, animations);
        this.init(useFlippedSpritesAsFallback);
    }

    public static String getSpriteName(Creature creature, CreatureAnimationState state) {
        return creature.getSpritesheetName() + "-" + state.spriteString();
    }

    public static String getSpriteName(Creature creature, CreatureAnimationState state, Direction direction) {
        return CreatureAnimationController.getSpriteName(creature, state) + "-" + direction.name().toLowerCase();
    }

    @Override
    public boolean isAutoScaling() {
        return ((Creature)this.getEntity()).isScaling() || super.isAutoScaling();
    }

    @Override
    protected String getSpritePrefix() {
        return ((Creature)this.getEntity()).getSpritesheetName();
    }

    protected String getCurrentAnimationName() {
        if (((Creature)this.getEntity()).isDead()) {
            return this.getDeathAnimationName();
        }
        if (((Creature)this.getEntity()).isIdle()) {
            String idleName = this.getIdleSpriteName(((Creature)this.getEntity()).getFacingDirection());
            if (this.hasAnimation(idleName)) {
                return idleName;
            }
            return this.getWalkSpriteName(((Creature)this.getEntity()).getFacingDirection());
        }
        String walkName = this.getWalkSpriteName(((Creature)this.getEntity()).getFacingDirection());
        if (this.hasAnimation(walkName)) {
            return walkName;
        }
        return this.getIdleSpriteName(((Creature)this.getEntity()).getFacingDirection());
    }

    private String getDeathAnimationName() {
        String deadName;
        if (this.customDeathAnimations.length > 0) {
            String randomDeathAnmimation;
            if (this.randomDeathSprite != null) {
                return this.randomDeathSprite;
            }
            String randomDeathAnim = Game.random().choose(this.customDeathAnimations);
            if (randomDeathAnim != null && !randomDeathAnim.isEmpty() && this.hasAnimation(randomDeathAnmimation = this.getSpritePrefix() + "-" + randomDeathAnim)) {
                this.randomDeathSprite = randomDeathAnmimation;
                return this.randomDeathSprite;
            }
        }
        if (this.hasAnimation(deadName = this.getSpriteName(CreatureAnimationState.DEAD))) {
            return deadName;
        }
        return null;
    }

    private void initializeAvailableAnimations() {
        Spritesheet baseWalk;
        Spritesheet baseIdle;
        for (Direction dir : Direction.values()) {
            Spritesheet idleSprite;
            Spritesheet walkSprite = Resources.spritesheets().get(this.getSpriteName(CreatureAnimationState.WALK, dir));
            if (walkSprite != null) {
                this.add(new Animation(walkSprite, true, new int[0]));
            }
            if ((idleSprite = Resources.spritesheets().get(this.getSpriteName(CreatureAnimationState.IDLE, dir))) == null) continue;
            this.add(new Animation(idleSprite, true, new int[0]));
        }
        Spritesheet deadSprite = Resources.spritesheets().get(this.getSpriteName(CreatureAnimationState.DEAD));
        if (deadSprite != null) {
            this.add(new Animation(deadSprite, true, new int[0]));
        }
        if ((baseIdle = Resources.spritesheets().get(this.getSpriteName(CreatureAnimationState.IDLE))) != null) {
            this.add(new Animation(baseIdle, true, new int[0]));
        }
        if ((baseWalk = Resources.spritesheets().get(this.getSpriteName(CreatureAnimationState.WALK))) != null) {
            this.add(new Animation(baseWalk, true, new int[0]));
        }
    }

    private void initializeFlippedAnimations() {
        String leftIdle = this.getSpriteName(CreatureAnimationState.IDLE, Direction.LEFT);
        String leftWalk = this.getSpriteName(CreatureAnimationState.WALK, Direction.LEFT);
        Optional<Animation> leftIdleAnimation = this.getAll().stream().filter(x -> x.getName().equals(leftIdle)).findFirst();
        Optional<Animation> leftWalkAnimation = this.getAll().stream().filter(x -> x.getName().equals(leftWalk)).findFirst();
        String rightIdle = this.getSpriteName(CreatureAnimationState.IDLE, Direction.RIGHT);
        String rightWalk = this.getSpriteName(CreatureAnimationState.WALK, Direction.RIGHT);
        Optional<Animation> rightIdleAnimation = this.getAll().stream().filter(x -> x.getName().equals(rightIdle)).findFirst();
        Optional<Animation> rightWalkAnimation = this.getAll().stream().filter(x -> x.getName().equals(rightWalk)).findFirst();
        if (!leftIdleAnimation.isPresent() && rightIdleAnimation.isPresent()) {
            this.add(CreatureAnimationController.flipAnimation(rightIdleAnimation.get(), leftIdle));
        }
        if (!leftWalkAnimation.isPresent() && rightWalkAnimation.isPresent()) {
            this.add(CreatureAnimationController.flipAnimation(rightWalkAnimation.get(), leftWalk));
        }
        if (!rightIdleAnimation.isPresent() && leftIdleAnimation.isPresent()) {
            this.add(CreatureAnimationController.flipAnimation(leftIdleAnimation.get(), rightIdle));
        }
        if (!rightWalkAnimation.isPresent() && leftWalkAnimation.isPresent()) {
            this.add(CreatureAnimationController.flipAnimation(leftWalkAnimation.get(), rightWalk));
        }
    }

    private String getIdleSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(CreatureAnimationState.IDLE, dir);
    }

    private String getWalkSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(CreatureAnimationState.WALK, dir);
    }

    private String getSpriteNameWithDirection(CreatureAnimationState state, Direction dir) {
        String name = this.getSpriteName(state, dir);
        if (this.hasAnimation(name)) {
            return name;
        }
        return this.getFallbackSpriteName(state, dir);
    }

    private String getFallbackSpriteName(CreatureAnimationState state, Direction dir) {
        String name;
        String fallbackStateName = this.getSpriteName(state.getOpposite(), dir);
        if (this.hasAnimation(fallbackStateName)) {
            return fallbackStateName;
        }
        String baseName = this.getSpriteName(state);
        if (this.hasAnimation(baseName)) {
            return baseName;
        }
        for (Direction d : Direction.values()) {
            name = this.getSpriteName(state, d);
            if (!this.hasAnimation(name)) continue;
            return name;
        }
        for (Direction d : Direction.values()) {
            name = this.getSpriteName(state.getOpposite(), d);
            if (!this.hasAnimation(name)) continue;
            return name;
        }
        return this.getDefault() != null ? this.getDefault().getName() : null;
    }

    private String getSpriteName(CreatureAnimationState state) {
        return CreatureAnimationController.getSpriteName((Creature)this.getEntity(), state);
    }

    private String getSpriteName(CreatureAnimationState state, Direction direction) {
        return CreatureAnimationController.getSpriteName((Creature)this.getEntity(), state, direction);
    }

    private void init(boolean useFlippedSpritesAsFallback) {
        this.initializeAvailableAnimations();
        if (useFlippedSpritesAsFallback) {
            this.initializeFlippedAnimations();
        }
        this.addRule(e -> true, e -> this.getCurrentAnimationName());
        AnimationInfo info = ((Creature)this.getEntity()).getClass().getAnnotation(AnimationInfo.class);
        this.customDeathAnimations = info != null ? info.deathAnimations() : new String[0];
    }
}

