/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Serializer {
    private static final Logger log = Logger.getLogger(Serializer.class.getName());

    private Serializer() {
        throw new UnsupportedOperationException();
    }

    public static Object deserialize(byte[] bytes) {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream o = new ObjectInputStream(b);
            return o.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static byte[] serialize(Object obj) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ObjectOutputStream o = new ObjectOutputStream(b);
            o.writeObject(obj);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return b.toByteArray();
    }
}

