/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

public class SerializationHelper {
    private SerializationHelper() {
        throw new UnsupportedOperationException();
    }

    public static float decodeAngle(byte encodedAngle) {
        float angle = encodedAngle;
        angle += 127.0f;
        angle /= 0.7111111f;
        return (angle += 360.0f) % 360.0f;
    }

    public static float decodeAngleFromShort(short encodedAngle) {
        return SerializationHelper.decodeSmallFloatingPointNumber(encodedAngle, 2);
    }

    public static float decodeSmallFloatingPointNumber(short encodedNumber, int precision) {
        return (float)((double)(encodedNumber + Short.MAX_VALUE) / Math.pow(10.0, precision));
    }

    public static byte encodeAngle(float angle) {
        float encodedAngle = angle % 360.0f;
        encodedAngle *= 0.7111111f;
        return (byte)(encodedAngle -= 127.0f);
    }

    public static short encodeAngleToShort(float angle) {
        float encodedAngle = angle;
        if (encodedAngle < 0.0f) {
            encodedAngle += 360.0f;
        }
        return SerializationHelper.encodeSmallFloatingPointNumber(encodedAngle %= 360.0f, 2);
    }

    public static short encodeSmallFloatingPointNumber(float smallNumber, int precision) {
        if (smallNumber < 0.0f || (int)((double)smallNumber * Math.pow(10.0, precision)) > 65534) {
            throw new IllegalArgumentException("The specified number is not within the range to encode.");
        }
        return (short)((double)smallNumber * Math.pow(10.0, precision) - 32767.0);
    }
}

