/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.geom;

public class Trigonometry {
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final float[] atan2;
    private static final int ATAN2_DIM;
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = 4095;
    private static final int SIN_COUNT = 4096;
    private static final float[] cos;
    private static final float DEG = 57.295776f;
    private static final float DEG_FULL = 360.0f;
    private static final float DEG_TO_INDEX = 11.377778f;
    private static final float INV_ATAN2_DIM_MINUS_1;
    private static final float RAD_FULL = (float)Math.PI * 2;
    private static final float RAD_TO_INDEX = 651.8986f;
    private static final float[] sin;

    private Trigonometry() {
        throw new UnsupportedOperationException();
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;
                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (atan2[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static final float atan2Deg(float y, float x) {
        return Trigonometry.atan2(y, x) * 57.295776f;
    }

    public static final float atan2DegStrict(float y, float x) {
        return (float)Math.atan2(y, x) * 57.295776f;
    }

    public static final float cos(float rad) {
        return cos[(int)(rad * 651.8986f) & 0xFFF];
    }

    public static final float cosDeg(float deg) {
        return cos[(int)(deg * 11.377778f) & 0xFFF];
    }

    public static final float sin(float rad) {
        return sin[(int)(rad * 651.8986f) & 0xFFF];
    }

    public static final float sinDeg(float deg) {
        return sin[(int)(deg * 11.377778f) & 0xFFF];
    }

    static {
        int i;
        atan2 = new float[16384];
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        cos = new float[4096];
        INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
        sin = new float[4096];
        for (i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                Trigonometry.atan2[j * Trigonometry.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
        for (i = 0; i < 4096; ++i) {
            Trigonometry.sin[i] = (float)Math.sin(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
            Trigonometry.cos[i] = (float)Math.cos(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
        }
    }
}

