/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.util.concurrent.TimeUnit;

public final class TimeUtilities {
    private TimeUtilities() {
        throw new UnsupportedOperationException();
    }

    public static double nanoToMs(long nano) {
        return (double)nano / 1000000.0;
    }

    public static long getDays(long ms) {
        return TimeUnit.MILLISECONDS.toDays(ms);
    }

    public static long getHours(long ms) {
        return TimeUnit.MILLISECONDS.toHours(ms);
    }

    public static long getMinutes(long ms) {
        return TimeUnit.MILLISECONDS.toMinutes(ms);
    }

    public static long getSeconds(long ms) {
        return TimeUnit.MILLISECONDS.toSeconds(ms);
    }

    public static long getRemainingDays(long ms) {
        return ms / 1000L / 60L / 60L / 24L % 365L;
    }

    public static long getRemainingHours(long ms) {
        return ms / 1000L / 60L / 60L % 24L;
    }

    public static long getRemainingMinutes(long ms) {
        return ms / 1000L / 60L % 60L;
    }

    public static long getRemainingSeconds(long ms) {
        return ms / 1000L % 60L;
    }

    public static long getRemainingMilliSeconds(long ms) {
        return ms % 1000L;
    }

    public static String toTimerFormat(long duration, TimerFormat format) {
        long h = TimeUtilities.getRemainingHours(duration);
        long m = TimeUtilities.getRemainingMinutes(duration);
        long s = TimeUtilities.getRemainingSeconds(duration);
        long ms = TimeUtilities.getRemainingMilliSeconds(duration);
        switch (format) {
            case HH_MM_SS: {
                return String.format(format.toFormatString(), h, m, s);
            }
            case HH_MM_SS_000: {
                return String.format(format.toFormatString(), h, m, s, ms);
            }
            case MM_SS_000: {
                return String.format(format.toFormatString(), m, s, ms);
            }
            case MM_SS_0: {
                return String.format(format.toFormatString(), m, s, ms / 100L);
            }
        }
        return Long.toString(ms);
    }

    public static enum TimerFormat {
        UNDEFINED,
        HH_MM_SS,
        MM_SS_000,
        MM_SS_0,
        HH_MM_SS_000,
        DD_HH_MM;


        public String toFormatString() {
            switch (this) {
                case HH_MM_SS: {
                    return "%02d:%02d:%02d";
                }
                case HH_MM_SS_000: {
                    return "%02d:%02d:%02d.%03d";
                }
                case MM_SS_000: {
                    return "%02d:%02d.%03d";
                }
                case MM_SS_0: {
                    return "%02d:%02d.%01d";
                }
            }
            return null;
        }
    }
}

