/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionUtilities {
    private static final Logger log = Logger.getLogger(ReflectionUtilities.class.getName());

    private ReflectionUtilities() {
        throw new UnsupportedOperationException();
    }

    public static <T> Field getField(Class<T> cls, String fieldName) {
        for (Field field : cls.getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static <T, C> void setValue(Class<C> cls, Object instance, String fieldName, T value) {
        try {
            Method method = ReflectionUtilities.getSetter(cls, fieldName);
            if (method != null) {
                method.invoke(instance, value);
            } else {
                for (Field field : cls.getDeclaredFields()) {
                    if (!field.getName().equals(fieldName) || field.getType() != value.getClass() && !ReflectionUtilities.isWrapperType(field.getType(), value.getClass()) && !ReflectionUtilities.isWrapperType(value.getClass(), field.getType())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(instance, value);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static <T> void setEnumPropertyValue(Class<T> cls, Object instance, Field field, String propertyName, String value) {
        ?[] enumArray;
        for (Object enumConst : enumArray = field.getType().getEnumConstants()) {
            if (enumConst == null || !enumConst.toString().equalsIgnoreCase(value)) continue;
            ReflectionUtilities.setValue(cls, instance, propertyName, field.getType().cast(enumConst));
        }
    }

    public static <T> Method getSetter(Class<T> cls, String fieldName) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equalsIgnoreCase("set" + fieldName) || method.getParameters().length != 1) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        return null;
    }

    public static <T, C> boolean isWrapperType(Class<T> primitive, Class<C> potentialWrapper) {
        if (!primitive.isPrimitive() || potentialWrapper.isPrimitive()) {
            return false;
        }
        if (primitive == Boolean.TYPE) {
            return potentialWrapper == Boolean.class;
        }
        if (primitive == Character.TYPE) {
            return potentialWrapper == Character.class;
        }
        if (primitive == Byte.TYPE) {
            return potentialWrapper == Byte.class;
        }
        if (primitive == Short.TYPE) {
            return potentialWrapper == Short.class;
        }
        if (primitive == Integer.TYPE) {
            return potentialWrapper == Integer.class;
        }
        if (primitive == Long.TYPE) {
            return potentialWrapper == Long.class;
        }
        if (primitive == Float.TYPE) {
            return potentialWrapper == Float.class;
        }
        if (primitive == Double.TYPE) {
            return potentialWrapper == Double.class;
        }
        if (primitive == Void.TYPE) {
            return potentialWrapper == Void.class;
        }
        return false;
    }

    public static <T> void setFieldValue(Class<T> cls, Object instance, String fieldName, String value) {
        Field field = ReflectionUtilities.getField(cls, fieldName);
        if (field == null) {
            return;
        }
        try {
            if (field.getType().equals(Boolean.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Boolean.parseBoolean(value));
            } else if (field.getType().equals(Integer.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Integer.parseInt(value));
            } else if (field.getType().equals(Float.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Float.valueOf(Float.parseFloat(value)));
            } else if (field.getType().equals(Double.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Double.parseDouble(value));
            } else if (field.getType().equals(Short.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Short.parseShort(value));
            } else if (field.getType().equals(Byte.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Byte.parseByte(value));
            } else if (field.getType().equals(Long.TYPE)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, Long.parseLong(value));
            } else if (field.getType().equals(String.class)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, value);
            } else if (field.getType().equals(String[].class)) {
                ReflectionUtilities.setValue(cls, instance, fieldName, value.split(","));
            } else if (field.getType() instanceof Class && field.getType().isEnum()) {
                ReflectionUtilities.setEnumPropertyValue(cls, instance, field, fieldName, value);
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

