/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class MathUtilities {
    private static Random random = new Random();

    private MathUtilities() {
        throw new UnsupportedOperationException();
    }

    public static boolean equals(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) <= epsilon;
    }

    public static float round(float value, int places) {
        return (float)MathUtilities.round((double)value, places);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double getAverage(double[] numbers) {
        double sum = 0.0;
        for (double number : numbers) {
            if (number == 0.0) continue;
            sum += number;
        }
        return sum / (double)numbers.length;
    }

    public static float getAverage(float[] numbers) {
        float sum = 0.0f;
        for (float number : numbers) {
            if (number == 0.0f) continue;
            sum += number;
        }
        return sum / (float)numbers.length;
    }

    public static int getAverage(int[] numbers) {
        int sum = 0;
        for (int number : numbers) {
            if (number == 0) continue;
            sum += number;
        }
        return sum / numbers.length;
    }

    public static int getMax(int ... numbers) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] <= max) continue;
            max = numbers[i];
        }
        return max;
    }

    public static int getRandomIndex(double[] indexProbabilities) {
        double rnd = random.nextDouble();
        double probSum = 0.0;
        for (int i = 0; i < indexProbabilities.length; ++i) {
            double newProbSum = probSum + indexProbabilities[i];
            if (rnd >= probSum && rnd < newProbSum) {
                return i;
            }
            probSum = newProbSum;
        }
        return 0;
    }

    public static boolean isInt(double value) {
        return value == Math.floor(value) && !Double.isInfinite(value);
    }

    public static boolean isOddNumber(int num) {
        return (num & 1) != 0;
    }

    public static boolean probabilityIsTrue(double probability) {
        double rnd = random.nextDouble();
        return rnd < probability;
    }

    public static boolean randomBoolean() {
        return random.nextDouble() < 0.5;
    }

    public static double randomInRange(double min, double max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            throw new IllegalArgumentException("min value is > than max value");
        }
        return min + random.nextDouble() * (max - min);
    }

    public static int randomInRange(int min, int max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            throw new IllegalArgumentException("min value is > than max value");
        }
        return random.nextInt(max - min) + min;
    }

    public static int randomSign() {
        return MathUtilities.randomBoolean() ? 1 : -1;
    }

    public static int getFullPercent(double value, double fraction) {
        if (value == 0.0) {
            return 0;
        }
        return (int)(fraction * 100.0 / value);
    }

    public static double getPercent(double value, double fraction) {
        if (value == 0.0) {
            return 0.0;
        }
        return (double)((float)fraction * 100.0f) / value;
    }
}

