/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import de.gurkenlabs.litiengine.util.ICommandListener;
import de.gurkenlabs.litiengine.util.ICommandManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ConsoleCommandListener
extends Thread
implements ICommandListener {
    private final List<ICommandManager> commandManagers;

    public ConsoleCommandListener(ICommandManager ... commandManagers) {
        this.setDaemon(true);
        this.commandManagers = new ArrayList<ICommandManager>();
        if (commandManagers != null && commandManagers.length > 0) {
            for (ICommandManager manager : commandManagers) {
                if (this.commandManagers.contains(manager)) continue;
                this.commandManagers.add(manager);
            }
        }
    }

    @Override
    public void register(ICommandManager manager) {
        if (!this.commandManagers.contains(manager)) {
            this.commandManagers.add(manager);
        }
    }

    @Override
    public void run() {
        Scanner scanner = new Scanner(System.in);
        while (!ConsoleCommandListener.interrupted()) {
            String s = scanner.nextLine();
            this.commandManagers.forEach(manager -> manager.executeCommand(s));
        }
        scanner.close();
    }

    @Override
    public void terminate() {
        this.interrupt();
    }
}

