/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ColorHelper {
    private static final Logger log = Logger.getLogger(ColorHelper.class.getName());
    private static final int HEX_STRING_LENGTH = 7;
    private static final int HEX_STRING_LENGTH_ALPHA = 9;
    private static final int MAX_RGB_VALUE = 255;

    private ColorHelper() {
        throw new UnsupportedOperationException();
    }

    public static String encode(Color color) {
        if (color == null) {
            return null;
        }
        String colorString = String.format("%08x", color.getRGB());
        if (color.getAlpha() == 255) {
            return "#" + colorString.substring(2);
        }
        return "#" + colorString;
    }

    public static Color decode(String colorHexString) {
        return ColorHelper.decode(colorHexString, false);
    }

    public static Color decode(String colorHexString, boolean solid) {
        if (colorHexString == null || colorHexString.isEmpty()) {
            return null;
        }
        if (!colorHexString.startsWith("#")) {
            if (colorHexString.length() == 6 || colorHexString.length() == 8) {
                colorHexString = "#" + colorHexString;
            } else {
                log.log(Level.SEVERE, "Could not parse color string \"{0}\". A color string needs to start with a \"#\" character.", colorHexString);
                return null;
            }
        }
        switch (colorHexString.length()) {
            case 7: {
                return ColorHelper.decodeWellformedHexString(colorHexString);
            }
            case 9: {
                return ColorHelper.decodeHexStringWithAlpha(colorHexString, solid);
            }
        }
        log.log(Level.SEVERE, "Could not parse color string \"{0}\". Invalid string length \"{1}\"!\nAccepted lengths:\n\t{2} for Colors without Alpha (#ff0000)\n\t{3} for Colors with Alpha (#c8ff0000)", new Object[]{colorHexString, colorHexString.length(), 7, 9});
        return null;
    }

    public static int ensureColorValueRange(float value) {
        return ColorHelper.ensureColorValueRange(Math.round(value));
    }

    public static int ensureColorValueRange(int value) {
        return Math.min(Math.max(value, 0), 255);
    }

    private static Color decodeWellformedHexString(String hexString) {
        try {
            return Color.decode(hexString);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static Color decodeHexStringWithAlpha(String hexString, boolean solid) {
        int alphaValue;
        String alpha = hexString.substring(1, 3);
        try {
            alphaValue = ColorHelper.ensureColorValueRange(Integer.parseInt(alpha, 16));
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        StringBuilder sb = new StringBuilder(hexString);
        sb.replace(1, 3, "");
        String baseColorString = sb.toString();
        Color baseColor = ColorHelper.decodeWellformedHexString(baseColorString);
        if (baseColor == null) {
            return null;
        }
        if (solid) {
            float alphaRatio = (float)alphaValue / 255.0f;
            int red = ColorHelper.ensureColorValueRange(alphaRatio * (float)baseColor.getRed());
            int green = ColorHelper.ensureColorValueRange(alphaRatio * (float)baseColor.getGreen());
            int blue = ColorHelper.ensureColorValueRange(alphaRatio * (float)baseColor.getBlue());
            return new Color(red, green, blue);
        }
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alphaValue);
    }
}

