/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.sound.ISoundPlayback;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.SoundEvent;
import de.gurkenlabs.litiengine.sound.SoundPlaybackListener;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

final class SoundPlayback
implements Runnable,
ISoundPlayback {
    private static final Logger log = Logger.getLogger(SoundPlayback.class.getName());
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
        private int id = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Sound Playback Thread " + ++this.id);
        }
    });
    private final List<SoundPlaybackListener> playbackListeners = new CopyOnWriteArrayList<SoundPlaybackListener>();
    private final Point2D initialListenerLocation;
    private SourceDataLine dataLine;
    private IEntity entity;
    private float gain;
    private float actualGain;
    private FloatControl gainControl;
    private FloatControl panControl;
    private Point2D location;
    private final Sound sound;
    private boolean playing;
    private boolean loop;
    private boolean cancelled;
    private boolean paused;
    private volatile Thread playingIn;

    SoundPlayback(Sound sound) {
        this(sound, null);
    }

    SoundPlayback(Sound sound, Point2D listenerLocation) {
        this.sound = sound;
        this.initialListenerLocation = listenerLocation;
        this.gain = 1.0f;
    }

    SoundPlayback(Sound sound, Point2D listenerLocation, IEntity sourceEntity) {
        this(sound, listenerLocation);
        this.entity = sourceEntity;
    }

    SoundPlayback(Sound sound, Point2D listenerLocation, Point2D location) {
        this(sound, listenerLocation);
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.playingIn = Thread.currentThread();
        this.playing = true;
        this.loadDataLine();
        if (this.dataLine == null) {
            return;
        }
        this.startDataLine();
        byte[] buffer = new byte[64];
        ByteArrayInputStream str = new ByteArrayInputStream(this.sound.getStreamData());
        while (!this.cancelled) {
            int readCount;
            if (this.isPaused()) {
                try {
                    SoundPlayback soundPlayback = this;
                    synchronized (soundPlayback) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.cancel();
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            if ((readCount = str.read(buffer, 0, buffer.length)) < 0) {
                SoundPlayback soundPlayback = this;
                synchronized (soundPlayback) {
                    if (!this.loop || this.dataLine == null) {
                        break;
                    }
                    this.restartDataLine();
                    str = new ByteArrayInputStream(this.sound.getStreamData());
                }
            } else if (this.dataLine != null) {
                this.dataLine.write(buffer, 0, readCount);
            }
            Thread.interrupted();
        }
        if (!this.cancelled) {
            if (this.dataLine != null) {
                this.dataLine.drain();
                this.dataLine.close();
            }
            SoundEvent event = new SoundEvent(this, this.sound);
            for (SoundPlaybackListener listener : this.playbackListeners) {
                listener.finished(event);
            }
        }
        this.playing = false;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.dispose();
        this.playingIn.interrupt();
        SoundEvent event = new SoundEvent(this, this.sound);
        for (SoundPlaybackListener listener : this.playbackListeners) {
            listener.cancelled(event);
        }
    }

    @Override
    public void addSoundPlaybackListener(SoundPlaybackListener soundPlaybackListener) {
        this.playbackListeners.add(soundPlaybackListener);
    }

    @Override
    public void removeSoundPlaybackListener(SoundPlaybackListener soundPlaybackListener) {
        this.playbackListeners.remove(soundPlaybackListener);
    }

    @Override
    public float getGain() {
        return this.gain;
    }

    @Override
    public void pausePlayback() {
        this.paused = true;
        this.playingIn.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumePlayback() {
        this.paused = false;
        SoundPlayback soundPlayback = this;
        synchronized (soundPlayback) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public void setGain(float gain) {
        this.gain = MathUtilities.clamp(gain, 0.0f, 1.0f);
    }

    protected static void terminate() {
        executorService.shutdownNow();
    }

    private synchronized void dispose() {
        if (this.dataLine != null) {
            this.dataLine.stop();
            this.dataLine.flush();
            this.dataLine.close();
        }
        this.dataLine = null;
        this.gainControl = null;
        this.panControl = null;
    }

    Sound getSound() {
        return this.sound;
    }

    void play() {
        this.play(false);
    }

    void play(boolean loop) {
        this.play(loop, Game.config().sound().getSoundVolume());
    }

    void play(boolean loop, float volume) {
        this.play(loop, null, volume);
    }

    void play(float volume) {
        this.play(false, null, volume);
    }

    void play(Point2D location) {
        this.play(false, location, Game.config().sound().getSoundVolume());
    }

    void play(boolean loop, Point2D location, float gain) {
        if (this.dataLine != null) {
            return;
        }
        this.actualGain = gain;
        this.location = location;
        this.loop = loop;
        executorService.execute(this);
    }

    void setMasterGain(float g) {
        if (this.gainControl == null) {
            return;
        }
        float newGain = MathUtilities.clamp(g * this.gain, 0.0f, 1.0f);
        double minimumDB = this.gainControl.getMinimum();
        double maximumDB = 1.0;
        double ampGainDB = 0.5 - minimumDB;
        double cste = Math.log(10.0) / 20.0;
        float valueDB = (float)(minimumDB + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * (double)newGain));
        this.gainControl.setValue(valueDB);
    }

    void updateControls(Point2D listenerLocation) {
        Point2D loc;
        if (listenerLocation == null) {
            return;
        }
        Point2D point2D = loc = this.entity != null ? this.entity.getCenter() : this.location;
        if (loc == null) {
            return;
        }
        this.setMasterGain(SoundPlayback.calculateGain(loc, listenerLocation));
        this.setPan(SoundPlayback.calculatePan(loc, listenerLocation));
    }

    private static float calculateGain(Point2D currentLocation, Point2D listenerLocation) {
        if (currentLocation == null || listenerLocation == null) {
            return 0.0f;
        }
        float distanceFromListener = (float)currentLocation.distance(listenerLocation);
        float gain = distanceFromListener <= 0.0f ? 1.0f : (distanceFromListener >= Game.audio().getMaxDistance() ? 0.0f : 1.0f - distanceFromListener / Game.audio().getMaxDistance());
        gain = MathUtilities.clamp(gain, 0.0f, 1.0f);
        return gain *= Game.config().sound().getSoundVolume();
    }

    private static float calculatePan(Point2D currentLocation, Point2D listenerLocation) {
        double angle = GeometricUtilities.calcRotationAngleInDegrees(listenerLocation, currentLocation);
        return (float)(-Math.sin(angle));
    }

    private void loadDataLine() {
        DataLine.Info dataInfo = new DataLine.Info(SourceDataLine.class, this.sound.getFormat());
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(dataInfo);
            if (!this.dataLine.isOpen()) {
                this.dataLine.open();
            }
        }
        catch (LineUnavailableException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void startDataLine() {
        this.initControls();
        this.updateControls(this.initialListenerLocation);
        this.dataLine.start();
    }

    private void restartDataLine() {
        this.dataLine.drain();
        this.loadDataLine();
        this.initControls();
        this.dataLine.start();
    }

    private void initControls() {
        if (this.dataLine == null) {
            return;
        }
        this.panControl = this.dataLine.isControlSupported(FloatControl.Type.PAN) ? (FloatControl)this.dataLine.getControl(FloatControl.Type.PAN) : null;
        this.gainControl = this.dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN) ? (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN) : null;
        this.setMasterGain(this.actualGain);
    }

    private void setPan(float p) {
        if (this.panControl == null) {
            return;
        }
        float pan = MathUtilities.clamp(p, -1.0f, 1.0f);
        this.panControl.setValue(pan);
    }
}

