/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.sound.ISoundEngine;
import de.gurkenlabs.litiengine.sound.ISoundPlayback;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.SoundPlayback;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public final class SoundEngine
implements ISoundEngine,
IUpdateable,
ILaunchable {
    public static final int DEFAULT_MAX_DISTANCE = 150;
    private Point2D listenerLocation;
    private Function<Point2D, Point2D> listenerLocationCallback;
    private float maxDist = 150.0f;
    private SoundPlayback music;
    private final List<SoundPlayback> sounds = Collections.synchronizedList(new ArrayList());

    public SoundEngine() {
        this.setListenerLocationCallback(old -> Game.world().camera().getFocus());
    }

    @Override
    public float getMaxDistance() {
        return this.maxDist;
    }

    @Override
    public ISoundPlayback playMusic(Sound sound) {
        return this.playMusic(sound, true);
    }

    @Override
    public ISoundPlayback playMusic(Sound sound, boolean loop) {
        if (sound == null || this.music != null && sound.equals(this.music.getSound())) {
            return null;
        }
        if (this.music != null) {
            this.music.cancel();
        }
        this.music = new SoundPlayback(sound);
        this.music.play(loop, Game.config().sound().getMusicVolume());
        return this.music;
    }

    @Override
    public ISoundPlayback playSound(IEntity entity, Sound sound) {
        return this.playSound(entity, sound, false);
    }

    @Override
    public ISoundPlayback playSound(IEntity entity, Sound sound, boolean loop) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = new SoundPlayback(sound, this.listenerLocation, entity);
        playback.play(loop);
        this.sounds.add(playback);
        return playback;
    }

    @Override
    public ISoundPlayback playSound(Point2D location, Sound sound) {
        return this.playSound(location, sound, false);
    }

    @Override
    public ISoundPlayback playSound(Point2D location, Sound sound, boolean loop) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = new SoundPlayback(sound, this.listenerLocation);
        playback.play(loop);
        this.sounds.add(playback);
        return playback;
    }

    @Override
    public ISoundPlayback playSound(Sound sound) {
        return this.playSound(sound, false);
    }

    @Override
    public ISoundPlayback playSound(Sound sound, boolean loop) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = new SoundPlayback(sound);
        playback.play(loop);
        this.sounds.add(playback);
        return playback;
    }

    @Override
    public void setMaxDistance(float radius) {
        this.maxDist = radius;
    }

    @Override
    public void start() {
        Input.getLoop().attach(this);
        this.listenerLocation = Game.world().camera().getFocus();
    }

    @Override
    public void stopMusic() {
        if (this.music == null) {
            return;
        }
        this.music.cancel();
        this.music = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Input.getLoop().detach(this);
        if (this.music != null && this.music.isPlaying()) {
            this.music.cancel();
            this.music = null;
        }
        List<SoundPlayback> list = this.sounds;
        synchronized (list) {
            for (SoundPlayback playback : this.sounds) {
                playback.cancel();
            }
            this.sounds.clear();
        }
        SoundPlayback.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        this.listenerLocation = this.listenerLocationCallback.apply(this.listenerLocation);
        List<SoundPlayback> list = this.sounds;
        synchronized (list) {
            Iterator<SoundPlayback> iter = this.sounds.iterator();
            while (iter.hasNext()) {
                SoundPlayback s = iter.next();
                if (s == null) continue;
                if (!s.isPlaying()) {
                    iter.remove();
                    continue;
                }
                s.updateControls(this.listenerLocation);
            }
        }
        if (this.music != null) {
            this.music.setMasterGain(Game.config().sound().getMusicVolume());
        }
        if (this.music != null && !this.music.isPlaying()) {
            this.playMusic(this.music.getSound());
        }
    }

    @Override
    public void setListenerLocationCallback(Function<Point2D, Point2D> listenerLocationCallback) {
        this.listenerLocationCallback = listenerLocationCallback;
    }
}

