/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Strings {
    public static final String DEFAULT_BUNDLE = "strings";
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static final Logger log = Logger.getLogger(ResourcesContainer.class.getName());
    private String encoding = "ISO-8859-1";

    Strings() {
        Locale.setDefault(new Locale("en", "US"));
    }

    public void setEncoding(String newEncoding) {
        if (newEncoding == null || newEncoding.isEmpty()) {
            throw new IllegalArgumentException("The encoding must not be null or empty.");
        }
        this.encoding = newEncoding;
    }

    public String get(String key) {
        if (key == null) {
            return null;
        }
        return this.getFrom(DEFAULT_BUNDLE, key, new Object[0]);
    }

    public String get(String key, Object ... args) {
        if (key == null) {
            return null;
        }
        return this.getFrom(DEFAULT_BUNDLE, key, args);
    }

    public String getFrom(String bundleName, String key, Object ... args) {
        if (bundleName == null || key == null) {
            return null;
        }
        try {
            String decodedValue;
            ResourceBundle defaultBundle = ResourceBundle.getBundle(bundleName, Game.config().client().getLocale());
            String value = defaultBundle.getString(key);
            String string = decodedValue = this.encoding.equals(ENCODING_ISO_8859_1) ? value : new String(value.getBytes(ENCODING_ISO_8859_1), this.encoding);
            if (args.length > 0) {
                return MessageFormat.format(decodedValue, args);
            }
            return decodedValue;
        }
        catch (UnsupportedEncodingException | MissingResourceException me) {
            StringWriter sw = new StringWriter();
            me.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            log.severe(stacktrace);
            return key;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getList(String textFile) {
        if (textFile == null) return new String[0];
        if (textFile.isEmpty()) {
            return new String[0];
        }
        try (InputStream is = FileUtilities.getGameResource(textFile);){
            if (is == null) {
                String[] stringArray2 = new String[]{};
                return stringArray2;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> strings = new ArrayList<String>();
            String str = "";
            while ((str = reader.readLine()) != null) {
                strings.add(str);
            }
            String[] stockArr = new String[strings.size()];
            String[] stringArray = strings.toArray(stockArr);
            return stringArray;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return new String[0];
        }
    }

    public boolean contains(String key) {
        return this.contains(DEFAULT_BUNDLE, key);
    }

    public boolean contains(String bundleName, String key) {
        try {
            ResourceBundle defaultBundle = ResourceBundle.getBundle(bundleName, Game.config().client().getLocale());
            return defaultBundle.containsKey(key);
        }
        catch (MissingResourceException me) {
            StringWriter sw = new StringWriter();
            me.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            log.severe(stacktrace);
            return false;
        }
    }
}

