/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.SpritesheetInfo;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Spritesheets
extends ResourcesContainer<Spritesheet> {
    private final Map<String, int[]> customKeyFrameDurations = new ConcurrentHashMap<String, int[]>();
    private static final Logger log = Logger.getLogger(Spritesheet.class.getName());
    private static final String SPRITE_INFO_COMMENT_CHAR = "#";

    Spritesheets() {
    }

    @Override
    public Spritesheet get(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String name = FileUtilities.getFileName(path).toLowerCase();
        return this.getResources().getOrDefault(name, null);
    }

    @Override
    public Spritesheet get(String resourceName, boolean forceLoad) {
        return this.get(resourceName);
    }

    public int[] getCustomKeyFrameDurations(String name) {
        return this.customKeyFrameDurations.getOrDefault(FileUtilities.getFileName(name).toLowerCase(), new int[0]);
    }

    public int[] getCustomKeyFrameDurations(Spritesheet sprite) {
        return this.getCustomKeyFrameDurations(sprite.getName());
    }

    public Spritesheet load(BufferedImage image, String path, int spriteWidth, int spriteHeight) {
        return new Spritesheet(image, path, spriteWidth, spriteHeight);
    }

    public Spritesheet load(ITileset tileset) {
        if (tileset == null || tileset.getImage() == null) {
            return null;
        }
        if (tileset.getImage().getAbsoluteSourcePath() == null) {
            return null;
        }
        return new Spritesheet((BufferedImage)Resources.images().get(tileset.getImage().getAbsoluteSourcePath(), true), tileset.getImage().getSource(), tileset.getTileDimension().width, tileset.getTileDimension().height);
    }

    public Spritesheet load(SpritesheetInfo info) {
        Spritesheet sprite = null;
        if (info.getImage() == null || info.getImage().isEmpty()) {
            log.log(Level.SEVERE, "Sprite {0} could not be loaded because no image is defined.", new Object[]{info.getName()});
            return null;
        }
        sprite = this.load(ImageProcessing.decodeToImage(info.getImage()), info.getName(), info.getWidth(), info.getHeight());
        if (info.getKeyframes() != null && info.getKeyframes().length > 0) {
            this.customKeyFrameDurations.put(sprite.getName().toLowerCase(), info.getKeyframes());
        }
        return sprite;
    }

    public List<Spritesheet> loadFrom(String spriteInfoFile) {
        ArrayList<Spritesheet> sprites = new ArrayList<Spritesheet>();
        InputStream fileStream = FileUtilities.getGameResource(spriteInfoFile);
        if (fileStream == null) {
            return sprites;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fileStream));){
            String line;
            while ((line = br.readLine()) != null) {
                List<String> items;
                String[] parts;
                if (line.isEmpty() || line.startsWith(SPRITE_INFO_COMMENT_CHAR) || (parts = line.split(";")).length == 0 || (items = Arrays.asList(parts[0].split("\\s*,\\s*"))).size() < 3) continue;
                this.getSpriteSheetFromSpriteInfoLine(FileUtilities.getParentDirPath(spriteInfoFile), sprites, items, parts);
            }
            log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{sprites.size(), spriteInfoFile});
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return sprites;
    }

    public Spritesheet load(String path, int spriteWidth, int spriteHeight) {
        return new Spritesheet((BufferedImage)Resources.images().get(path, true), path, spriteWidth, spriteHeight);
    }

    @Override
    public Spritesheet remove(String path) {
        Spritesheet spriteToRemove = (Spritesheet)super.remove(path.toLowerCase());
        this.customKeyFrameDurations.remove(path);
        return spriteToRemove;
    }

    public void update(SpritesheetInfo info) {
        if (info == null || info.getName() == null) {
            return;
        }
        String spriteName = info.getName().toLowerCase();
        Spritesheet spriteToRemove = this.remove(spriteName);
        if (spriteToRemove != null) {
            this.customKeyFrameDurations.remove(spriteName);
            if (info.getHeight() == 0 && info.getWidth() == 0) {
                return;
            }
            this.load(info);
        }
    }

    private void getSpriteSheetFromSpriteInfoLine(String baseDirectory, ArrayList<Spritesheet> sprites, List<String> items, String[] parts) {
        try {
            List<String> keyFrameStrings;
            String name = baseDirectory + items.get(0);
            int width = Integer.parseInt(items.get(1));
            int height = Integer.parseInt(items.get(2));
            Spritesheet sprite = this.load(name, width, height);
            sprites.add(sprite);
            if (parts.length >= 2 && !(keyFrameStrings = Arrays.asList(parts[1].split("\\s*,\\s*"))).isEmpty()) {
                int[] keyFrames = new int[keyFrameStrings.size()];
                for (int i = 0; i < keyFrameStrings.size(); ++i) {
                    int keyFrame;
                    keyFrames[i] = keyFrame = Integer.parseInt(keyFrameStrings.get(i));
                }
                this.customKeyFrameDurations.put(sprite.getName().toLowerCase(), keyFrames);
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected Spritesheet load(String resourceName) {
        return null;
    }
}

