/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.resources.ResourcesContainerClearedListener;
import de.gurkenlabs.litiengine.resources.ResourcesContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ResourcesContainer<T> {
    private static final Logger log = Logger.getLogger(ResourcesContainer.class.getName());
    private final Map<String, T> resources = new ConcurrentHashMap<String, T>();
    private final Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final List<ResourcesContainerListener<T>> listeners = new CopyOnWriteArrayList<ResourcesContainerListener<T>>();
    private final List<ResourcesContainerClearedListener> clearedListeners = new CopyOnWriteArrayList<ResourcesContainerClearedListener>();

    protected ResourcesContainer() {
    }

    public void addContainerListener(ResourcesContainerListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeContainerListener(ResourcesContainerListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void addClearedListener(ResourcesContainerClearedListener listener) {
        this.clearedListeners.add(listener);
    }

    public void removeClearedListener(ResourcesContainerClearedListener listener) {
        this.clearedListeners.remove(listener);
    }

    public void add(String resourceName, T resource) {
        String identifier = resourceName.toLowerCase();
        this.resources.put(identifier, resource);
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.added(resourceName, resource);
        }
    }

    public void clear() {
        this.resources.clear();
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.cleared();
        }
    }

    public boolean contains(String resourceName) {
        return this.resources.containsKey(resourceName.toLowerCase());
    }

    public boolean contains(T resource) {
        return this.resources.containsValue(resource);
    }

    public int count() {
        return this.resources.size();
    }

    public Collection<T> get(Predicate<T> pred) {
        if (pred == null) {
            return new ArrayList();
        }
        return this.resources.values().stream().filter(pred).collect(Collectors.toList());
    }

    public T get(String resourceName) {
        return this.get(resourceName, false);
    }

    public T get(String resourceName, Supplier<T> loadCallback) {
        String identifier = resourceName.toLowerCase();
        Optional<T> opt = this.tryGet(identifier);
        if (opt.isPresent()) {
            return opt.get();
        }
        T resource = loadCallback.get();
        this.add(identifier, resource);
        return resource;
    }

    public T get(String resourceName, boolean forceLoad) {
        if (resourceName == null) {
            return null;
        }
        String identifier = this.getIdentifier(resourceName);
        if (forceLoad) {
            T resource = this.loadResource(identifier);
            this.resources.put(identifier, resource);
            return resource;
        }
        return (T)this.resources.computeIfAbsent(identifier, this::loadResource);
    }

    public Collection<T> getAll() {
        return this.resources.values();
    }

    public T remove(String resourceName) {
        T removedResource = this.resources.remove(resourceName.toLowerCase());
        if (removedResource != null) {
            for (ResourcesContainerListener<T> listener : this.listeners) {
                listener.removed(resourceName, removedResource);
            }
        }
        return removedResource;
    }

    public Optional<T> tryGet(String resourceName) {
        if (this.contains(resourceName)) {
            return Optional.of(this.get(resourceName));
        }
        return Optional.empty();
    }

    protected abstract T load(String var1) throws Exception;

    protected String getAlias(String resourceName, T resource) {
        return null;
    }

    protected Map<String, T> getResources() {
        return this.resources;
    }

    private T loadResource(String identifier) {
        T newResource;
        try {
            newResource = this.load(identifier);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not load the game resource.", e);
            return null;
        }
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.added(identifier, newResource);
        }
        String alias = this.getAlias(identifier, newResource);
        if (alias != null) {
            this.aliases.put(alias.toLowerCase(), identifier);
        }
        return newResource;
    }

    private String getIdentifier(String resourceName) {
        String res = resourceName.toLowerCase();
        if (this.resources.containsKey(res)) {
            return res;
        }
        return this.aliases.getOrDefault(res, res);
    }
}

