/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.GameData;
import de.gurkenlabs.litiengine.SpritesheetInfo;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.resources.Fonts;
import de.gurkenlabs.litiengine.resources.Images;
import de.gurkenlabs.litiengine.resources.Maps;
import de.gurkenlabs.litiengine.resources.Sounds;
import de.gurkenlabs.litiengine.resources.Spritesheets;
import de.gurkenlabs.litiengine.resources.Strings;
import de.gurkenlabs.litiengine.resources.Tilesets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Resources {
    private static final Logger log = Logger.getLogger(Resources.class.getName());
    private static Fonts fonts = new Fonts();
    private static Sounds sounds = new Sounds();
    private static Maps maps = new Maps();
    private static Tilesets tilesets = new Tilesets();
    private static Strings strings = new Strings();
    private static Images images = new Images();
    private static Spritesheets spritesheets = new Spritesheets();

    private Resources() {
        throw new UnsupportedOperationException();
    }

    public static Fonts fonts() {
        return fonts;
    }

    public static Sounds sounds() {
        return sounds;
    }

    public static Maps maps() {
        return maps;
    }

    public static Tilesets tilesets() {
        return tilesets;
    }

    public static Strings strings() {
        return strings;
    }

    public static Images images() {
        return images;
    }

    public static Spritesheets spritesheets() {
        return spritesheets;
    }

    /*
     * WARNING - void declaration
     */
    public static void load(String gameResourceFile) {
        void var5_11;
        GameData file = GameData.load(gameResourceFile);
        if (file == null) {
            return;
        }
        int mapCnt = 0;
        for (IMap iMap : file.getMaps()) {
            Resources.maps().add(iMap.getName(), iMap);
            ++mapCnt;
        }
        log.log(Level.INFO, "{0} maps loaded from {1}", new Object[]{mapCnt, gameResourceFile});
        int tileCnt = 0;
        for (Tileset tileset : file.getTilesets()) {
            if (Resources.tilesets().contains(tileset.getName())) continue;
            Resources.tilesets().add(tileset.getName(), tileset);
            ++tileCnt;
        }
        log.log(Level.INFO, "{0} tilesets loaded from {1}", new Object[]{tileCnt, gameResourceFile});
        ArrayList<Spritesheet> arrayList = new ArrayList<Spritesheet>();
        for (SpritesheetInfo tileset : file.getSpriteSheets()) {
            Spritesheet sprite = Resources.spritesheets().load(tileset);
            arrayList.add(sprite);
        }
        log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{arrayList.size(), gameResourceFile});
        boolean bl = false;
        for (Spritesheet s : arrayList) {
            for (int i = 0; i < s.getRows() * s.getColumns(); ++i) {
                BufferedImage sprite = s.getSprite(i);
                if (sprite == null) continue;
                ++var5_11;
            }
        }
        log.log(Level.INFO, "{0} sprites loaded to memory", new Object[]{(int)var5_11});
    }
}

