/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxException;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import javax.xml.bind.JAXBException;

public final class Maps
extends ResourcesContainer<IMap> {
    Maps() {
    }

    public static boolean isSupported(String fileName) {
        String extension = FileUtilities.getExtension(fileName);
        return extension != null && !extension.isEmpty() && extension.equalsIgnoreCase("tmx");
    }

    @Override
    protected IMap load(String resourceName) throws TmxException {
        Map map;
        if (!Maps.isSupported(resourceName)) {
            return null;
        }
        try {
            map = XmlUtilities.readFromFile(Map.class, resourceName);
        }
        catch (JAXBException e) {
            throw new TmxException("could not parse xml data", e);
        }
        if (map == null) {
            return null;
        }
        String basePath = FileUtilities.getParentDirPath(resourceName);
        for (Tileset tilesets : map.getRawTilesets()) {
            tilesets.loadFromSource(basePath);
        }
        for (TileLayer layer : map.getRawTileLayers()) {
            layer.setTilesetEntries(map);
        }
        String name = FileUtilities.getFileName(resourceName);
        map.setName(name);
        map.setPath(resourceName);
        map.updateTileTerrain();
        return map;
    }

    @Override
    protected String getAlias(String resourceName, IMap resource) {
        if (resource == null || resource.getName() == null || resource.getName().isEmpty() || resource.getName().equalsIgnoreCase(resourceName)) {
            return null;
        }
        return resource.getName();
    }
}

