/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Fonts
extends ResourcesContainer<Font> {
    private static final Logger log = Logger.getLogger(Fonts.class.getName());

    Fonts() {
    }

    @Override
    protected Font load(String resourceName) {
        try {
            InputStream fontStream = FileUtilities.getGameResource(resourceName);
            if (fontStream == null) {
                log.log(Level.SEVERE, "font {0} could not be loaded", resourceName);
                return null;
            }
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return Font.getFont(resourceName);
        }
    }
}

