/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.physics.CollisionType;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public final class PhysicsEngine
implements IUpdateable {
    private final List<ICollisionEntity> collisionEntities;
    private Rectangle2D environmentBounds;
    private final List<Rectangle2D> staticCollisionBoxes;
    private final List<CollisionBox> entityCollisionBoxes = new CopyOnWriteArrayList<CollisionBox>();
    private final List<CollisionBox> allCollisionBoxes;
    private final List<CollisionBox> staticBoxes;
    private final List<Rectangle2D> allCollisionBoxRectangles;
    private final List<Rectangle2D> entityCollisionBoxRectangles;

    public PhysicsEngine() {
        this.collisionEntities = new CopyOnWriteArrayList<ICollisionEntity>();
        this.staticCollisionBoxes = new CopyOnWriteArrayList<Rectangle2D>();
        this.allCollisionBoxes = new CopyOnWriteArrayList<CollisionBox>();
        this.staticBoxes = new CopyOnWriteArrayList<CollisionBox>();
        this.allCollisionBoxRectangles = new CopyOnWriteArrayList<Rectangle2D>();
        this.entityCollisionBoxRectangles = new CopyOnWriteArrayList<Rectangle2D>();
    }

    public void add(ICollisionEntity entity) {
        Prop prop;
        if (entity instanceof Prop && (prop = (Prop)entity).isObstacle()) {
            this.add(prop.getCollisionBox());
            return;
        }
        if (!this.collisionEntities.contains(entity)) {
            this.collisionEntities.add(entity);
        }
    }

    public void add(Rectangle2D staticCollisionBox) {
        if (!this.staticCollisionBoxes.contains(staticCollisionBox)) {
            this.staticCollisionBoxes.add(staticCollisionBox);
        }
    }

    public void remove(ICollisionEntity entity) {
        Prop prop;
        if (entity instanceof Prop && (prop = (Prop)entity).isObstacle()) {
            this.remove(prop.getCollisionBox());
            return;
        }
        this.collisionEntities.remove(entity);
    }

    public void remove(Rectangle2D staticCollisionBox) {
        this.staticCollisionBoxes.remove(staticCollisionBox);
    }

    public void clear() {
        this.staticCollisionBoxes.clear();
        this.collisionEntities.clear();
        this.setBounds(null);
    }

    public List<Rectangle2D> getAllCollisionBoxes() {
        return this.getAllCollisionBoxRectangles();
    }

    public List<ICollisionEntity> getCollisionEntities() {
        return this.collisionEntities;
    }

    public List<Rectangle2D> getStaticCollisionBoxes() {
        return this.staticCollisionBoxes;
    }

    public Rectangle2D getBounds() {
        return this.environmentBounds;
    }

    public void setBounds(Rectangle2D environmentBounds) {
        this.environmentBounds = environmentBounds;
    }

    public boolean collides(double x, double y) {
        return this.collides(new Point2D.Double(x, y));
    }

    public boolean collides(double x, double y, CollisionType collisionType) {
        return this.collides((Point2D)new Point2D.Double(x, y), collisionType);
    }

    public boolean collides(double x, double y, ICollisionEntity collisionEntity) {
        return this.collides((Point2D)new Point2D.Double(x, y), collisionEntity);
    }

    public boolean collides(Point2D point, ICollisionEntity collisionEntity) {
        return this.collidesWithAnyEntity(collisionEntity, point) || this.collidesWithAnyStaticCollisionBox(point);
    }

    public boolean collides(Point2D point, CollisionType collisionType) {
        switch (collisionType) {
            case ALL: {
                return this.collides(point);
            }
            case ENTITY: {
                return this.collidesWithAnyEntity(null, point);
            }
            case STATIC: {
                return this.collidesWithAnyStaticCollisionBox(point);
            }
        }
        return false;
    }

    public Point2D collides(Line2D rayCast, CollisionType collisionType) {
        Point2D.Double rayCastSource = new Point2D.Double(rayCast.getX1(), rayCast.getY1());
        List<Rectangle2D> collBoxes = this.getAllCollisionBoxRectangles(collisionType);
        for (Rectangle2D collisionBox : collBoxes) {
            if (!collisionBox.intersectsLine(rayCast)) continue;
            double closestDist = -1.0;
            Point2D closestPoint = null;
            for (Point2D intersection : GeometricUtilities.getIntersectionPoints(rayCast, collisionBox)) {
                double dist = intersection.distance(rayCastSource);
                if (closestPoint != null && !(dist < closestDist)) continue;
                closestPoint = intersection;
                closestDist = dist;
            }
            return closestPoint;
        }
        return null;
    }

    public Point2D collides(Line2D rayCast) {
        return this.collides(rayCast, CollisionType.ALL);
    }

    public boolean collides(Point2D point) {
        if (this.environmentBounds != null && !this.environmentBounds.contains(point)) {
            return true;
        }
        for (Rectangle2D collisionBox : this.getAllCollisionBoxes()) {
            if (!collisionBox.contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean collides(Rectangle2D rect) {
        for (Rectangle2D collisionBox : this.getAllCollisionBoxes()) {
            if (!GeometricUtilities.intersects(rect, collisionBox)) continue;
            return true;
        }
        return false;
    }

    public boolean collides(Rectangle2D rect, CollisionType collisionType) {
        return this.collides(rect, null, collisionType);
    }

    public boolean collides(Rectangle2D rect, ICollisionEntity collisionEntity) {
        return this.collides(rect, collisionEntity, CollisionType.ALL);
    }

    public boolean collides(Rectangle2D rect, ICollisionEntity collisionEntity, CollisionType collisionType) {
        switch (collisionType) {
            case ALL: {
                return this.collides(rect);
            }
            case ENTITY: {
                return this.collidesWithAnyEntity(collisionEntity, rect) != null;
            }
            case STATIC: {
                return this.collidesWithAnyStaticCollisionBox(rect) != null;
            }
        }
        return false;
    }

    public boolean collides(ICollisionEntity collisionEntity) {
        return this.collides(collisionEntity, CollisionType.ALL);
    }

    public boolean collides(ICollisionEntity collisionEntity, CollisionType collisionType) {
        return this.collides(collisionEntity.getCollisionBox(), collisionEntity, collisionType);
    }

    public boolean move(IMobileEntity entity, double angle, double delta) {
        Point2D newPosition = GeometricUtilities.project(entity.getLocation(), angle, delta);
        return this.move(entity, newPosition);
    }

    public boolean move(IMobileEntity entity, Direction direction, double delta) {
        return this.move(entity, direction.toAngle(), delta);
    }

    public boolean move(IMobileEntity entity, double x, double y, float delta) {
        return this.move(entity, new Point2D.Double(x, y), delta);
    }

    public boolean move(IMobileEntity entity, float delta) {
        return this.move(entity, entity.getAngle(), (double)delta);
    }

    public boolean move(IMobileEntity entity, Point2D newLocation) {
        if (entity.turnOnMove()) {
            entity.setAngle(GeometricUtilities.calcRotationAngleInDegrees(entity.getLocation(), newLocation));
        }
        if (!this.isInMap(entity.getCollisionBox(newLocation))) {
            newLocation = this.clamptoMap(entity, newLocation);
        }
        if (!entity.hasCollision()) {
            entity.setLocation(newLocation);
            return true;
        }
        if (this.resolveCollisionForNewPosition(entity, newLocation)) {
            return false;
        }
        if (this.resolveCollisionForRaycastToNewPosition(entity, newLocation)) {
            return false;
        }
        entity.setLocation(newLocation);
        return true;
    }

    public boolean move(IMobileEntity entity, Point2D target, float delta) {
        Point2D newPosition = GeometricUtilities.project(entity.getLocation(), target, (double)delta);
        return this.move(entity, newPosition);
    }

    @Override
    public void update() {
        this.updateAllCollisionBoxes();
    }

    private List<CollisionBox> getAllCollisionBoxesInternal() {
        if (this.allCollisionBoxes.isEmpty()) {
            this.updateAllCollisionBoxes();
        }
        return this.allCollisionBoxes;
    }

    private List<Rectangle2D> getAllCollisionBoxRectangles() {
        if (this.allCollisionBoxRectangles.isEmpty()) {
            this.updateAllCollisionBoxes();
        }
        return this.allCollisionBoxRectangles;
    }

    private List<Rectangle2D> getAllCollisionBoxRectangles(CollisionType collisionType) {
        switch (collisionType) {
            case ENTITY: {
                return this.entityCollisionBoxRectangles;
            }
            case STATIC: {
                return this.staticCollisionBoxes;
            }
        }
        return this.getAllCollisionBoxRectangles();
    }

    private void updateAllCollisionBoxes() {
        this.allCollisionBoxes.clear();
        this.entityCollisionBoxes.clear();
        this.staticBoxes.clear();
        this.entityCollisionBoxes.addAll(this.collisionEntities.stream().filter(ICollisionEntity::hasCollision).map(x$0 -> new CollisionBox((ICollisionEntity)x$0)).collect(Collectors.toList()));
        this.staticBoxes.addAll(this.staticCollisionBoxes.stream().map(x$0 -> new CollisionBox((Rectangle2D)x$0)).collect(Collectors.toList()));
        this.allCollisionBoxes.addAll(this.entityCollisionBoxes);
        this.allCollisionBoxes.addAll(this.staticBoxes);
        this.allCollisionBoxRectangles.clear();
        this.entityCollisionBoxRectangles.clear();
        this.entityCollisionBoxRectangles.addAll(this.entityCollisionBoxes.stream().map(CollisionBox::getCollisionBox).collect(Collectors.toList()));
        this.allCollisionBoxRectangles.addAll(this.allCollisionBoxes.stream().map(CollisionBox::getCollisionBox).collect(Collectors.toList()));
    }

    private Rectangle2D collidesWithAnyEntity(ICollisionEntity entity, Rectangle2D collisionBox) {
        for (ICollisionEntity otherEntity : this.collisionEntities) {
            if (otherEntity == null || !otherEntity.hasCollision() || entity != null && otherEntity.equals(entity) || entity != null && !entity.canCollideWith(otherEntity) || !GeometricUtilities.intersects(otherEntity.getCollisionBox(), collisionBox)) continue;
            return otherEntity.getCollisionBox().createIntersection(collisionBox);
        }
        return null;
    }

    private boolean collidesWithAnyEntity(ICollisionEntity entity, Point2D location) {
        for (ICollisionEntity otherEntity : this.collisionEntities) {
            if (otherEntity == null || !otherEntity.hasCollision() || entity != null && otherEntity.equals(entity) || entity != null && !entity.canCollideWith(otherEntity) || !otherEntity.getCollisionBox().contains(location)) continue;
            return true;
        }
        return false;
    }

    private Rectangle2D collidesWithAnyStaticCollisionBox(Rectangle2D entityCollisionBox) {
        for (Rectangle2D collisionBox : this.staticCollisionBoxes) {
            if (!GeometricUtilities.intersects(collisionBox, entityCollisionBox)) continue;
            return collisionBox.createIntersection(entityCollisionBox);
        }
        return null;
    }

    private boolean collidesWithAnyStaticCollisionBox(Point2D location) {
        for (Rectangle2D collisionBox : this.staticCollisionBoxes) {
            if (!collisionBox.contains(location)) continue;
            return true;
        }
        return false;
    }

    private Rectangle2D collidesWithAnything(ICollisionEntity entity, Rectangle2D entityCollisionBox) {
        for (CollisionBox collisionBox : this.allCollisionBoxes) {
            if (collisionBox.getEntity() != null && (collisionBox.getEntity().equals(entity) || !entity.canCollideWith(collisionBox.getEntity()))) continue;
            if (collisionBox.getCollisionBox().contains(entityCollisionBox)) {
                return collisionBox.getCollisionBox();
            }
            if (!GeometricUtilities.intersects(collisionBox.getCollisionBox(), entityCollisionBox)) continue;
            return collisionBox.getCollisionBox().createIntersection(entityCollisionBox);
        }
        return null;
    }

    private boolean isInMap(Shape collisionBox) {
        if (this.environmentBounds == null) {
            return true;
        }
        return this.environmentBounds.contains(collisionBox.getBounds());
    }

    private Point2D resolveCollision(IMobileEntity entity, Point2D targetPosition) {
        Point2D.Double resolvedPosition = new Point2D.Double(targetPosition.getX(), entity.getY());
        Rectangle2D targetCollisionBoxX = entity.getCollisionBox(resolvedPosition);
        Rectangle2D intersectionX = this.collidesWithAnything(entity, targetCollisionBoxX);
        if (intersectionX != null) {
            if (entity.getCollisionBox().getX() < targetCollisionBoxX.getX()) {
                ((Point2D)resolvedPosition).setLocation(Math.max(entity.getX(), ((Point2D)resolvedPosition).getX() - intersectionX.getWidth()), ((Point2D)resolvedPosition).getY());
            } else {
                ((Point2D)resolvedPosition).setLocation(Math.min(entity.getX(), ((Point2D)resolvedPosition).getX() + intersectionX.getWidth()), ((Point2D)resolvedPosition).getY());
            }
        }
        ((Point2D)resolvedPosition).setLocation(((Point2D)resolvedPosition).getX(), targetPosition.getY());
        Rectangle2D targetCollisionBoxY = entity.getCollisionBox(resolvedPosition);
        Rectangle2D intersectionY = this.collidesWithAnything(entity, targetCollisionBoxY);
        if (intersectionY != null) {
            if (entity.getCollisionBox().getY() < targetCollisionBoxY.getY()) {
                ((Point2D)resolvedPosition).setLocation(((Point2D)resolvedPosition).getX(), Math.max(entity.getY(), ((Point2D)resolvedPosition).getY() - intersectionY.getHeight()));
            } else {
                ((Point2D)resolvedPosition).setLocation(((Point2D)resolvedPosition).getX(), Math.min(entity.getY(), ((Point2D)resolvedPosition).getY() + intersectionY.getHeight()));
            }
        }
        return resolvedPosition;
    }

    private Point2D clamptoMap(IMobileEntity entity, Point2D newLocation) {
        double collisionLocationX = entity.getCollisionBoxAlign().getLocation(entity.getWidth(), entity.getCollisionBoxWidth());
        double leftBoundX = this.getBounds().getMinX() - collisionLocationX;
        double deltaX = (double)(entity.getWidth() - entity.getCollisionBoxWidth()) - collisionLocationX;
        double rightBoundX = this.getBounds().getMaxX() - (double)entity.getWidth() + deltaX;
        double collisionLocationY = entity.getCollisionBoxValign().getLocation(entity.getHeight(), entity.getCollisionBoxHeight());
        double topBoundY = this.getBounds().getMinY() - collisionLocationY;
        double deltaY = (double)(entity.getHeight() - entity.getCollisionBoxHeight()) - collisionLocationY;
        double buttomBoundY = this.getBounds().getMaxY() - (double)entity.getHeight() + deltaY;
        double x = MathUtilities.clamp(newLocation.getX(), leftBoundX, rightBoundX);
        double y = MathUtilities.clamp(newLocation.getY(), topBoundY, buttomBoundY);
        return new Point2D.Double(x, y);
    }

    private boolean resolveCollisionForNewPosition(IMobileEntity entity, Point2D location) {
        if (this.collidesWithAnything(entity, entity.getCollisionBox(location)) != null) {
            Point2D resolvedPosition = this.resolveCollision(entity, location);
            entity.setLocation(resolvedPosition);
            return true;
        }
        return false;
    }

    private boolean resolveCollisionForRaycastToNewPosition(IMobileEntity entity, Point2D newPosition) {
        Line2D.Double line = new Line2D.Double(entity.getCollisionBox().getCenterX(), entity.getCollisionBox().getCenterY(), entity.getCollisionBox(newPosition).getCenterX(), entity.getCollisionBox(newPosition).getCenterY());
        for (CollisionBox collisionBox : this.getAllCollisionBoxesInternal()) {
            Point2D intersection;
            if (collisionBox.getEntity() != null && (collisionBox.getEntity().equals(entity) || !entity.canCollideWith(collisionBox.getEntity())) || (intersection = GeometricUtilities.getIntersectionPoint((Line2D)line, collisionBox.getCollisionBox())) == null) continue;
            return true;
        }
        return false;
    }

    private class CollisionBox {
        private final Rectangle2D box;
        private final ICollisionEntity entity;

        private CollisionBox(Rectangle2D box) {
            this.box = box;
            this.entity = null;
        }

        private CollisionBox(ICollisionEntity entity) {
            this.box = entity.getCollisionBox();
            this.entity = entity;
        }

        public Rectangle2D getCollisionBox() {
            return this.box;
        }

        public ICollisionEntity getEntity() {
            return this.entity;
        }
    }
}

