/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.Force;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MovementController<T extends IMobileEntity>
implements IMovementController {
    private static final double FORCE_APPLY_ACCEPTED_ERROR = 0.1;
    private final List<Force> activeForces = new CopyOnWriteArrayList<Force>();
    private final T mobileEntity;
    private final List<Predicate<IMobileEntity>> movementPredicates = new CopyOnWriteArrayList<Predicate<IMobileEntity>>();
    private final List<Consumer<Point2D>> movedConsumer = new CopyOnWriteArrayList<Consumer<Point2D>>();
    private float dx;
    private float dy;
    private boolean movedX;
    private boolean movedY;
    private double velocityX;
    private double velocityY;

    public MovementController(T mobileEntity) {
        this.mobileEntity = mobileEntity;
    }

    @Override
    public void attach() {
        Game.loop().attach(this);
    }

    @Override
    public void detach() {
        Game.loop().detach(this);
    }

    @Override
    public void apply(Force force) {
        if (!this.activeForces.contains(force)) {
            this.activeForces.add(force);
        }
    }

    @Override
    public List<Force> getActiveForces() {
        return this.activeForces;
    }

    public T getEntity() {
        return this.mobileEntity;
    }

    @Override
    public float getDx() {
        return this.dx;
    }

    @Override
    public void setDx(float dx) {
        this.dx = dx;
        this.setMovedX(this.dx != 0.0f);
    }

    @Override
    public float getDy() {
        return this.dy;
    }

    @Override
    public void setDy(float dy) {
        this.dy = dy;
        this.setMovedY(this.dy != 0.0f);
    }

    @Override
    public void onMovementCheck(Predicate<IMobileEntity> predicate) {
        if (!this.movementPredicates.contains(predicate)) {
            this.movementPredicates.add(predicate);
        }
    }

    @Override
    public void update() {
        this.handleForces();
        this.handleMovement();
    }

    @Override
    public void onMoved(Consumer<Point2D> cons) {
        this.movedConsumer.add(cons);
    }

    public void handleMovement() {
        double newVelocity;
        double dec;
        if (!this.isMovementAllowed()) {
            this.velocityX = 0.0;
            this.velocityY = 0.0;
            return;
        }
        double maxPixelsPerTick = this.getEntity().getTickVelocity();
        long deltaTime = Game.loop().getDeltaTime();
        double accelerationRatio = (double)deltaTime / (double)this.getEntity().getAcceleration();
        double decelerationRatio = (double)deltaTime / (double)this.getEntity().getDeceleration();
        double inc = this.getEntity().getAcceleration() == 0 ? maxPixelsPerTick : accelerationRatio * maxPixelsPerTick;
        double d = dec = this.getEntity().getDeceleration() == 0 ? maxPixelsPerTick : decelerationRatio * maxPixelsPerTick;
        if (this.isMovedX() && this.isMovedY()) {
            inc /= Math.sqrt(2.0);
        }
        if (this.isMovedX()) {
            newVelocity = this.getVelocityX() + (this.getDx() > 0.0f ? inc : -inc);
            this.setVelocityX(MathUtilities.clamp(newVelocity, -maxPixelsPerTick, maxPixelsPerTick));
            this.setDx(0.0f);
        } else {
            this.decellerateVelocityX(dec);
        }
        if (this.isMovedY()) {
            newVelocity = this.getVelocityY() + (this.getDy() > 0.0f ? inc : -inc);
            newVelocity = MathUtilities.clamp(newVelocity, -maxPixelsPerTick, maxPixelsPerTick);
            this.setVelocityY(newVelocity);
            this.setDy(0.0f);
        } else {
            this.decellerateVelocityY(dec);
        }
        if (this.getVelocityX() == 0.0 && this.getVelocityY() == 0.0) {
            return;
        }
        this.moveEntity(this.getVelocityX(), this.getVelocityY());
    }

    public boolean isMovedX() {
        return this.movedX;
    }

    public void setMovedX(boolean movedX) {
        this.movedX = movedX;
    }

    public boolean isMovedY() {
        return this.movedY;
    }

    public void setMovedY(boolean movedY) {
        this.movedY = movedY;
    }

    public double getVelocityX() {
        return this.velocityX;
    }

    protected void setVelocityX(double velocityX) {
        this.velocityX = velocityX;
    }

    protected void setVelocityY(double velocityY) {
        this.velocityY = velocityY;
    }

    public void decellerateVelocityX(double dec) {
        if (this.getVelocityX() > 0.0) {
            if (dec > this.getVelocityX()) {
                this.setVelocityX(0.0);
            } else {
                this.setVelocityX(this.getVelocityX() - dec);
            }
        } else if (this.getVelocityX() < 0.0) {
            if (dec < this.getVelocityX()) {
                this.setVelocityX(0.0);
            } else {
                this.setVelocityX(this.getVelocityX() + dec);
            }
        }
        if (Math.abs(this.getVelocityX()) < this.getStopThreshold()) {
            this.setVelocityX(0.0);
        }
    }

    public void decellerateVelocityY(double dec) {
        if (this.getVelocityY() > 0.0) {
            if (dec > this.getVelocityY()) {
                this.setVelocityY(0.0);
            } else {
                this.setVelocityY(this.getVelocityY() - dec);
            }
        } else if (this.getVelocityY() < 0.0) {
            if (dec < this.getVelocityY()) {
                this.setVelocityY(0.0);
            } else {
                this.setVelocityY(this.getVelocityY() + dec);
            }
        }
        if (Math.abs(this.getVelocityY()) < this.getStopThreshold()) {
            this.setVelocityY(0.0);
        }
    }

    public double getVelocityY() {
        return this.velocityY;
    }

    protected double getStopThreshold() {
        return 0.0025 * (double)Game.loop().getDeltaTime();
    }

    protected void moveEntity(double deltaX, double deltaY) {
        Point2D.Double newLocation = new Point2D.Double(this.getEntity().getX() + deltaX, this.getEntity().getY() + deltaY);
        Point2D oldLocation = this.getEntity().getLocation();
        Game.physics().move((IMobileEntity)this.getEntity(), newLocation);
        Point2D.Double delta = new Point2D.Double(this.getEntity().getX() - oldLocation.getX(), this.getEntity().getY() - oldLocation.getY());
        for (Consumer<Point2D> cons : this.movedConsumer) {
            cons.accept(delta);
        }
    }

    protected boolean isMovementAllowed() {
        for (Predicate<IMobileEntity> predicate : this.movementPredicates) {
            if (predicate.test((IMobileEntity)this.getEntity())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleForces() {
        this.activeForces.forEach(x -> {
            if (x.hasEnded()) {
                this.activeForces.remove(x);
            }
        });
        boolean turn = this.getEntity().turnOnMove();
        this.getEntity().setTurnOnMove(false);
        try {
            for (Force force : this.activeForces) {
                if (force.cancelOnReached() && force.hasReached((ICollisionEntity)this.getEntity())) {
                    force.end();
                    continue;
                }
                Point2D collisionBoxCenter = this.getEntity().getCollisionBoxCenter();
                if (collisionBoxCenter.distance(force.getLocation()) < 0.1) {
                    double yDelta = (double)this.getEntity().getHeight() - this.getEntity().getCollisionBox().getHeight() + this.getEntity().getCollisionBox().getHeight() / 2.0;
                    Point2D.Double entityLocation = new Point2D.Double(force.getLocation().getX() - (double)(this.getEntity().getWidth() / 2.0f), force.getLocation().getY() - yDelta);
                    this.getEntity().setLocation(entityLocation);
                    continue;
                }
                double angle = GeometricUtilities.calcRotationAngleInDegrees(collisionBoxCenter, force.getLocation());
                boolean success = Game.physics().move((IMobileEntity)this.getEntity(), (float)angle, (double)((float)Game.loop().getDeltaTime() * 0.001f * force.getStrength() * Game.loop().getTimeScale()));
                if (!force.cancelOnCollision() || success) continue;
                force.end();
            }
        }
        finally {
            this.getEntity().setTurnOnMove(turn);
        }
    }
}

