/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.pathfinding.astar;

import java.awt.Point;
import java.awt.Rectangle;

public class AStarNode {
    private static final double DIAGONAL_COST = 1.4;
    private final Rectangle bound;
    private final int gridX;
    private final int gridY;
    private double gCost;
    private double hCost;
    private double penalty;
    private AStarNode predecessor;
    private boolean walkable;

    public AStarNode(boolean walkable, Rectangle bound, int gridX, int gridY) {
        this.bound = bound;
        this.gridX = gridX;
        this.gridY = gridY;
        this.walkable = walkable;
    }

    public Rectangle getBounds() {
        return this.bound;
    }

    public double getCosts(AStarNode target) {
        int dstY;
        int dstX = Math.abs(this.getGridX() - target.getGridX());
        if (dstX > (dstY = Math.abs(this.getGridY() - target.getGridY()))) {
            return 1.4 * (double)dstY + (double)(dstX - dstY) + this.getPenalty();
        }
        return 1.4 * (double)dstX + (double)(dstY - dstX) + this.getPenalty();
    }

    public double getFCost() {
        return this.getGCost() + this.getHCost();
    }

    public double getGCost() {
        return this.gCost;
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public double getHCost() {
        return this.hCost;
    }

    public Point getLocation() {
        return new Point((int)this.getBounds().getCenterX(), (int)this.getBounds().getCenterY());
    }

    public double getPenalty() {
        return this.penalty;
    }

    public AStarNode getPredecessor() {
        return this.predecessor;
    }

    public boolean isWalkable() {
        return this.walkable;
    }

    public void setGCost(double gCost) {
        this.gCost = gCost;
    }

    public void setHCost(double hCost) {
        this.hCost = hCost;
    }

    public void setPenalty(double penalty) {
        this.penalty = penalty;
    }

    public void setPredecessor(AStarNode predecessor) {
        this.predecessor = predecessor;
    }

    public void setWalkable(boolean walkable) {
        this.walkable = walkable;
    }

    public void clear() {
        this.setGCost(0.0);
        this.setHCost(0.0);
        this.setPredecessor(null);
    }

    public String toString() {
        return "[" + this.getGridX() + "," + this.getGridY() + "] - (f:" + this.getFCost() + ", g:" + this.getGCost() + ", h:" + this.getHCost() + ")";
    }
}

