/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.messages.handlers;

import de.gurkenlabs.litiengine.net.messages.IMessageHandler;
import de.gurkenlabs.litiengine.net.messages.IMessageHandlerProvider;
import de.gurkenlabs.litiengine.net.messages.MessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class MessageHandlerProvider
implements IMessageHandlerProvider {
    private final HashMap<MessageType, List<IMessageHandler>> messageHandlers = new HashMap();

    public MessageHandlerProvider() {
        this.initializeHandlers();
    }

    @Override
    public List<IMessageHandler> getMessageHanders(MessageType type) {
        if (this.getMessageHandlers().containsKey(type)) {
            return this.getMessageHandlers().get(type);
        }
        return new ArrayList<IMessageHandler>();
    }

    @Override
    public void register(MessageType messageType, IMessageHandler messageHandler) {
        if (!this.getMessageHandlers().containsKey(messageType)) {
            this.getMessageHandlers().put(messageType, new ArrayList());
        }
        if (this.getMessageHandlers().get(messageType).contains(messageHandler)) {
            return;
        }
        this.getMessageHandlers().get(messageType).add(messageHandler);
    }

    protected HashMap<MessageType, List<IMessageHandler>> getMessageHandlers() {
        return this.messageHandlers;
    }

    protected abstract void initializeHandlers();
}

