/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MessageType {
    public static final MessageType INVALID = new MessageType("INVALID", -1);
    public static final MessageType INVALIDVERSION = new MessageType("INVALIDVERSION", 18);
    public static final MessageType LOGIN = new MessageType("LOGIN", 0);
    public static final MessageType LOGINRESPONSE = new MessageType("LOGINRESPONSE", 5);
    public static final MessageType LOGOUT = new MessageType("LOGOUT", 1);
    public static final MessageType PING = new MessageType("PING", 4);
    private static final List<MessageType> messageTypes = new ArrayList<MessageType>();
    private final String name;
    private final byte packetId;

    public MessageType(String name, byte messageId) {
        if (messageTypes.stream().anyMatch(type -> type.getId() == messageId)) {
            throw new IllegalArgumentException(String.format("Cannot create a new message type with packetId '%d' because another message type has an equal id assigned.", messageId));
        }
        if (messageTypes.stream().anyMatch(type -> type.getName() == name)) {
            throw new IllegalArgumentException(String.format("Cannot create a new message type with name '%s' because another message type has an equal name.", name));
        }
        this.name = name;
        this.packetId = messageId;
        messageTypes.add(this);
    }

    public static MessageType get(byte id) {
        Optional<MessageType> optional = messageTypes.stream().filter(m -> m.getId() == id).findAny();
        if (!optional.isPresent()) {
            return INVALID;
        }
        return optional.get();
    }

    public static MessageType get(String name) {
        Optional<MessageType> optional = messageTypes.stream().filter(m -> m.getName().equals(name)).findAny();
        if (!optional.isPresent()) {
            return INVALID;
        }
        return optional.get();
    }

    public byte getId() {
        return this.packetId;
    }

    public String getName() {
        return this.name;
    }
}

