/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.messages;

import de.gurkenlabs.litiengine.net.Packet;
import de.gurkenlabs.litiengine.net.messages.MessageType;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.io.CompressionUtilities;
import de.gurkenlabs.litiengine.util.io.Serializer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessagePacket<T>
extends Packet {
    private static final Logger log = Logger.getLogger(MessagePacket.class.getName());
    private static final int CONTENTLENGTHBYTECOUNT = 7;
    private T object;
    private int size;

    public MessagePacket(byte packetId) {
        super(packetId);
    }

    public MessagePacket(byte[] content) {
        super(content);
        boolean headerOffset = true;
        int dataOffset = 8;
        ByteBuffer wrapped = ByteBuffer.wrap(Arrays.copyOfRange(content, 1, 8));
        this.size = 7 + wrapped.getInt();
        byte[] objectBytes = Arrays.copyOfRange(content, 8, this.getSize() + 8);
        try {
            Object dataObject = Serializer.deserialize(objectBytes);
            this.object = dataObject;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.object = null;
        }
    }

    public MessagePacket(MessageType type, T object) {
        super(type.getId());
        this.object = object;
    }

    @Override
    public byte[] getData() {
        if (super.getData() != null && super.getData().length > 0) {
            return super.getData();
        }
        byte[] header = new byte[]{this.getPacketId()};
        byte[] serializedObject = Serializer.serialize(this.object);
        byte[] objectSize = ByteBuffer.allocate(7).putInt(serializedObject.length).array();
        byte[] data = ArrayUtilities.arrayConcat(header, ArrayUtilities.arrayConcat(objectSize, serializedObject));
        data = CompressionUtilities.compress(data);
        this.setData(data);
        return data;
    }

    public T getObject() {
        return this.object;
    }

    public int getSize() {
        return this.size;
    }
}

