/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.net.client;

import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.net.IPacketSender;
import de.gurkenlabs.litiengine.net.messages.ClientMessage;
import de.gurkenlabs.litiengine.net.messages.IMessageHandlerProvider;
import de.gurkenlabs.litiengine.net.messages.MessagePacket;
import de.gurkenlabs.litiengine.net.messages.MessageType;
import de.gurkenlabs.litiengine.net.messages.PingResponseMessage;
import de.gurkenlabs.litiengine.net.messages.handlers.ClientMessageHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PingLoop
extends ClientMessageHandler<PingResponseMessage>
implements ILaunchable {
    private static final Logger log = Logger.getLogger(PingLoop.class.getName());
    private final int clientId;
    private PingThread pingThread;
    private final List<Consumer<Long>> pingRecordConsumer = new ArrayList<Consumer<Long>>();
    private final int port;
    private final IPacketSender sender;
    private final String serverIpAdress;

    public PingLoop(int clientId, IMessageHandlerProvider provider, IPacketSender sender, String serverIpAdress, int port) {
        this.clientId = clientId;
        this.sender = sender;
        this.serverIpAdress = serverIpAdress;
        this.port = port;
        provider.register(MessageType.PING, this);
    }

    public void onPingRecorded(Consumer<Long> consumer) {
        if (this.pingRecordConsumer.contains(consumer)) {
            return;
        }
        this.pingRecordConsumer.add(consumer);
    }

    @Override
    public void start() {
        this.pingThread = new PingThread();
        this.pingThread.start();
    }

    @Override
    public void terminate() {
        this.pingThread.terminate();
    }

    @Override
    protected void handle(PingResponseMessage message, InetAddress address, int port) {
        if (this.pingThread == null) {
            return;
        }
        try {
            if (address.getHostAddress().equals(InetAddress.getByName(this.serverIpAdress).getHostAddress())) {
                this.pingThread.pingAnswerReceived();
            }
        }
        catch (UnknownHostException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private class PingThread
    extends Thread
    implements ILaunchable {
        private static final int TIME_BETWEEN_PINGS = 1000;
        private boolean isTerminated;
        private long lastPing;

        private PingThread() {
        }

        public void pingAnswerReceived() {
            long after = System.currentTimeMillis();
            long ping = after - this.lastPing;
            for (Consumer consumer : PingLoop.this.pingRecordConsumer) {
                consumer.accept(ping);
            }
        }

        @Override
        public void run() {
            while (!this.isTerminated) {
                this.lastPing = System.currentTimeMillis();
                MessagePacket<ClientMessage> packet = new MessagePacket<ClientMessage>(MessageType.PING, new ClientMessage(PingLoop.this.clientId));
                PingLoop.this.sender.sendData(packet, PingLoop.this.serverIpAdress, PingLoop.this.port);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                    this.interrupt();
                }
            }
        }

        @Override
        public void terminate() {
            this.isTerminated = true;
        }
    }
}

