/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.pathfinding.IEntityNavigator;
import de.gurkenlabs.litiengine.physics.MovementController;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MousePathController
extends MovementController<IMobileEntity> {
    private boolean navigating;
    private final IEntityNavigator navigator;

    public MousePathController(IEntityNavigator navigator, IMobileEntity entity) {
        super(entity);
        this.navigator = navigator;
        Input.mouse().onPressed(this::mousePressed);
        Input.mouse().onReleased(this::mouseReleased);
    }

    public IEntityNavigator getNavigator() {
        return this.navigator;
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.navigating = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.navigating = false;
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.isMovementAllowed() || !this.getActiveForces().isEmpty()) {
            this.navigator.stop();
            return;
        }
        if (this.navigating) {
            this.navigator.navigate(Input.mouse().getMapLocation());
        }
    }
}

