/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.input.IKeyboard;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class Keyboard
implements KeyEventDispatcher,
IKeyboard {
    private final List<KeyListener> keyListeners = new CopyOnWriteArrayList<KeyListener>();
    private final List<Map.Entry<Integer, Consumer<KeyEvent>>> keySpecificPressedConsumer = new CopyOnWriteArrayList<Map.Entry<Integer, Consumer<KeyEvent>>>();
    private final List<Map.Entry<Integer, Consumer<KeyEvent>>> keySpecificReleasedConsumer = new CopyOnWriteArrayList<Map.Entry<Integer, Consumer<KeyEvent>>>();
    private final List<Map.Entry<Integer, Consumer<KeyEvent>>> keySpecificTypedConsumer = new CopyOnWriteArrayList<Map.Entry<Integer, Consumer<KeyEvent>>>();
    private final List<Consumer<KeyEvent>> keyPressedConsumer = new CopyOnWriteArrayList<Consumer<KeyEvent>>();
    private final List<Consumer<KeyEvent>> keyReleasedConsumer = new CopyOnWriteArrayList<Consumer<KeyEvent>>();
    private final List<Consumer<KeyEvent>> keyTypedConsumer = new CopyOnWriteArrayList<Consumer<KeyEvent>>();
    private final List<KeyEvent> pressedKeys = new CopyOnWriteArrayList<KeyEvent>();
    private final List<KeyEvent> releasedKeys = new CopyOnWriteArrayList<KeyEvent>();
    private final List<KeyEvent> typedKeys = new CopyOnWriteArrayList<KeyEvent>();
    private boolean consumeAlt;

    protected Keyboard() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        Input.getLoop().attach(this);
        this.consumeAlt = true;
    }

    @Override
    public void consumeAlt(boolean consume) {
        this.consumeAlt = consume;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.consumeAlt && e.getKeyCode() == 18) {
            e.consume();
        }
        int eventId = e.getID();
        switch (eventId) {
            case 401: {
                this.addPressedKey(e);
                break;
            }
            case 402: {
                this.removePressedKey(e);
                this.addTypedKey(e);
                this.addReleasedKey(e);
                break;
            }
        }
        return false;
    }

    @Override
    public String getText(KeyEvent e) {
        if (this.isPressed(16) || Toolkit.getDefaultToolkit().getLockingKeyState(20)) {
            return this.getShiftText(e);
        }
        if (this.isPressed(65406)) {
            return this.getAltText(e);
        }
        return this.getNormalText(e);
    }

    @Override
    public boolean isPressed(int keyCode) {
        for (KeyEvent key : this.pressedKeys) {
            if (key.getKeyCode() != keyCode) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onKeyPressed(int keyCode, Consumer<KeyEvent> consumer) {
        this.keySpecificPressedConsumer.add(new AbstractMap.SimpleEntry<Integer, Consumer<KeyEvent>>(keyCode, consumer));
    }

    @Override
    public void onKeyReleased(int keyCode, Consumer<KeyEvent> consumer) {
        this.keySpecificReleasedConsumer.add(new AbstractMap.SimpleEntry<Integer, Consumer<KeyEvent>>(keyCode, consumer));
    }

    @Override
    public void onKeyTyped(int keyCode, Consumer<KeyEvent> consumer) {
        this.keySpecificTypedConsumer.add(new AbstractMap.SimpleEntry<Integer, Consumer<KeyEvent>>(keyCode, consumer));
    }

    @Override
    public void onKeyPressed(Consumer<KeyEvent> consumer) {
        this.keyPressedConsumer.add(consumer);
    }

    @Override
    public void onKeyReleased(Consumer<KeyEvent> consumer) {
        this.keyReleasedConsumer.add(consumer);
    }

    @Override
    public void onKeyTyped(Consumer<KeyEvent> consumer) {
        this.keyTypedConsumer.add(consumer);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.keyListeners.contains(listener)) {
            return;
        }
        this.keyListeners.add(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
    }

    @Override
    public void update() {
        this.executePressedKeys();
        this.executeReleasedKeys();
        this.executeTypedKeys();
    }

    private void addPressedKey(KeyEvent keyCode) {
        if (this.pressedKeys.stream().anyMatch(key -> key.getKeyCode() == keyCode.getKeyCode())) {
            return;
        }
        this.pressedKeys.add(keyCode);
    }

    private void addReleasedKey(KeyEvent keyCode) {
        if (this.releasedKeys.stream().anyMatch(key -> key.getKeyCode() == keyCode.getKeyCode())) {
            return;
        }
        this.releasedKeys.add(keyCode);
    }

    private void addTypedKey(KeyEvent keyCode) {
        if (this.typedKeys.stream().anyMatch(key -> key.getKeyCode() == keyCode.getKeyCode())) {
            return;
        }
        this.typedKeys.add(keyCode);
    }

    private void executePressedKeys() {
        this.pressedKeys.forEach(key -> {
            this.keySpecificPressedConsumer.forEach(consumer -> {
                if (((Integer)consumer.getKey()).intValue() == key.getKeyCode()) {
                    ((Consumer)consumer.getValue()).accept(key);
                }
            });
            this.keyPressedConsumer.forEach(consumer -> consumer.accept(key));
            this.keyListeners.forEach(listener -> listener.keyPressed((KeyEvent)key));
        });
    }

    private void executeReleasedKeys() {
        this.releasedKeys.forEach(key -> {
            this.keySpecificReleasedConsumer.forEach(consumer -> {
                if (((Integer)consumer.getKey()).intValue() == key.getKeyCode()) {
                    ((Consumer)consumer.getValue()).accept(key);
                }
            });
            this.keyReleasedConsumer.forEach(consumer -> consumer.accept(key));
            this.keyListeners.forEach(listener -> listener.keyReleased((KeyEvent)key));
        });
        this.releasedKeys.clear();
    }

    private void executeTypedKeys() {
        this.typedKeys.forEach(key -> {
            this.keySpecificTypedConsumer.forEach(consumer -> {
                if (((Integer)consumer.getKey()).intValue() == key.getKeyCode()) {
                    ((Consumer)consumer.getValue()).accept(key);
                }
            });
            this.keyTypedConsumer.forEach(consumer -> consumer.accept(key));
            this.keyListeners.forEach(listener -> listener.keyTyped((KeyEvent)key));
        });
        this.typedKeys.clear();
    }

    private void removePressedKey(KeyEvent keyCode) {
        for (KeyEvent removeKey : this.pressedKeys) {
            if (removeKey.getKeyCode() != keyCode.getKeyCode()) continue;
            this.pressedKeys.remove(removeKey);
            return;
        }
    }

    private String getNormalText(KeyEvent e) {
        if (e.getExtendedKeyCode() == KeyEvent.getExtendedKeyCodeForChar(223)) {
            return "\u00df";
        }
        switch (e.getKeyCode()) {
            case 96: {
                return "0";
            }
            case 97: {
                return "1";
            }
            case 98: {
                return "2";
            }
            case 99: {
                return "3";
            }
            case 100: {
                return "4";
            }
            case 101: {
                return "5";
            }
            case 102: {
                return "6";
            }
            case 103: {
                return "7";
            }
            case 104: {
                return "8";
            }
            case 105: {
                return "9";
            }
            case 520: {
                return "#";
            }
            case 46: {
                return ".";
            }
            case 44: {
                return ",";
            }
            case 107: 
            case 521: {
                return "+";
            }
            case 45: 
            case 109: {
                return "-";
            }
            case 106: {
                return "*";
            }
            case 111: {
                return "/";
            }
        }
        if (KeyEvent.getKeyText(e.getKeyCode()).length() == 1) {
            String text = Character.toString(e.getKeyChar());
            text = text.toLowerCase();
            return text;
        }
        return "";
    }

    private String getAltText(KeyEvent e) {
        if (e.getExtendedKeyCode() == KeyEvent.getExtendedKeyCodeForChar(223)) {
            return "\\";
        }
        switch (e.getKeyCode()) {
            case 48: {
                return "}";
            }
            case 50: {
                return "\u00b2";
            }
            case 51: {
                return "\u00b3";
            }
            case 55: {
                return "{";
            }
            case 56: {
                return "[";
            }
            case 57: {
                return "]";
            }
            case 69: {
                return "\u20ac";
            }
            case 81: {
                return "@";
            }
            case 77: {
                return "\u00b5";
            }
            case 521: {
                return "~";
            }
        }
        return "";
    }

    private String getShiftText(KeyEvent e) {
        if (e.getExtendedKeyCode() == KeyEvent.getExtendedKeyCodeForChar(223)) {
            return "?";
        }
        switch (e.getKeyCode()) {
            case 48: {
                return "=";
            }
            case 49: {
                return "!";
            }
            case 50: {
                return "\"";
            }
            case 51: {
                return "\u00a7";
            }
            case 52: {
                return "$";
            }
            case 53: {
                return "%";
            }
            case 54: {
                return "&";
            }
            case 55: {
                return "/";
            }
            case 56: {
                return "(";
            }
            case 57: {
                return ")";
            }
            case 520: {
                return "'";
            }
            case 46: {
                return ":";
            }
            case 44: {
                return ";";
            }
            case 521: {
                return "*";
            }
            case 45: {
                return "_";
            }
        }
        if (KeyEvent.getKeyText(e.getKeyCode()).length() == 1) {
            return Character.toString(e.getKeyChar());
        }
        return "";
    }
}

