/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameAdapter;
import de.gurkenlabs.litiengine.GameLoop;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.input.GamepadManager;
import de.gurkenlabs.litiengine.input.IGamepad;
import de.gurkenlabs.litiengine.input.IGamepadManager;
import de.gurkenlabs.litiengine.input.IKeyboard;
import de.gurkenlabs.litiengine.input.IMouse;
import de.gurkenlabs.litiengine.input.Keyboard;
import de.gurkenlabs.litiengine.input.Mouse;
import java.awt.AWTException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Input {
    private static final Logger log = Logger.getLogger(Input.class.getName());
    private static final IGameLoop InputLoop = new GameLoop("Input Loop", Game.loop().getUpdateRate());
    private static IGamepadManager gamePadManager;
    private static List<IGamepad> gamePads;
    private static IKeyboard keyboard;
    private static IMouse mouse;

    private Input() {
        throw new UnsupportedOperationException();
    }

    public static IGameLoop getLoop() {
        return InputLoop;
    }

    public static IGamepadManager gamepadManager() {
        return gamePadManager;
    }

    public static IKeyboard keyboard() {
        return keyboard;
    }

    public static IMouse mouse() {
        return mouse;
    }

    public static List<IGamepad> gamepads() {
        return gamePads;
    }

    public static IGamepad getGamepad() {
        if (gamePads.isEmpty()) {
            return null;
        }
        return gamePads.get(0);
    }

    public static IGamepad getGamepad(int index) {
        if (gamePads.isEmpty()) {
            return null;
        }
        for (IGamepad gamepad : gamePads) {
            if (gamepad.getIndex() != index) continue;
            return gamepad;
        }
        return null;
    }

    private static final void init() {
        try {
            keyboard = new Keyboard();
            mouse = new Mouse();
            if (Game.config().input().isGamepadSupport()) {
                gamePads = new CopyOnWriteArrayList<IGamepad>();
                gamePadManager = new GamepadManager();
            }
        }
        catch (AWTException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static final class InputGameAdapter
    extends GameAdapter {
        @Override
        public void terminated() {
            InputLoop.terminate();
            if (gamePadManager != null) {
                gamePadManager.terminate();
            }
        }

        @Override
        public void initialized(String ... args) {
            Input.init();
        }

        @Override
        public void started() {
            InputLoop.start();
            if (gamePadManager != null) {
                gamePadManager.start();
            }
        }
    }
}

