/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IEntityProvider;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.gui.GuiProperties;
import de.gurkenlabs.litiengine.gui.SpeechBubbleAppearance;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SpeechBubble
implements IUpdateable,
IRenderable,
IEntityProvider {
    public static final SpeechBubbleAppearance DEFAULT_APPEARANCE = new SpeechBubbleAppearance(Color.WHITE, new Color(16, 20, 19, 150), new Color(16, 20, 19), 4.0f);
    private static final Map<IEntity, SpeechBubble> activeSpeechBubbles = new ConcurrentHashMap<IEntity, SpeechBubble>();
    private static final int DISPLAYTIME_MIN = 2000;
    private static final int DISPLAYTIME_PER_LETTER = 120;
    private static final int LETTER_WRITE_DELAY = 30;
    private Font font;
    private static final double TRIANGLE_SIZE = 6.0;
    private final int currentTextDisplayTime;
    private final Queue<Character> currentTextQueue;
    private final SpeechBubbleAppearance appearance;
    private BufferedImage bubble;
    private String currentText;
    private String displayedText;
    private final IEntity entity;
    private long lastCharPoll;
    private long lastTextDispay;
    private float textBoxWidth;
    private Sound typeSound;
    private Point2D entityCenter;

    private SpeechBubble(IEntity entity, String text, SpeechBubbleAppearance appearance, Font font) {
        this.appearance = appearance == null ? DEFAULT_APPEARANCE : appearance;
        SpeechBubble active = activeSpeechBubbles.get(entity);
        if (active != null) {
            active.cancel();
        }
        this.setFont(font);
        this.textBoxWidth = entity.getWidth() * 4.0f;
        this.entity = entity;
        this.currentText = text;
        this.currentTextDisplayTime = 2000 + text.length() * 120;
        this.currentTextQueue = new ConcurrentLinkedQueue<Character>();
        this.displayedText = "";
        for (int i = 0; i < this.currentText.length(); ++i) {
            this.currentTextQueue.add(Character.valueOf(this.currentText.charAt(i)));
        }
        this.lastTextDispay = Game.loop().getTicks();
        this.createBubbleImage();
        Game.world().environment().add(this, RenderType.UI);
        Game.renderLoop().attach(this);
        activeSpeechBubbles.put(entity, this);
    }

    private SpeechBubble(IEntity entity, String text, Sound typeSound, SpeechBubbleAppearance appearance, Font font) {
        this(entity, text, appearance, font);
        this.typeSound = typeSound;
    }

    public static SpeechBubble create(IEntity entity, String text, SpeechBubbleAppearance appearance, Font font) {
        return new SpeechBubble(entity, text, appearance, font);
    }

    public static SpeechBubble create(IEntity entity, String text) {
        return new SpeechBubble(entity, text, null, GuiProperties.getDefaultFont());
    }

    public static SpeechBubble create(IEntity entity, Font font, String text) {
        SpeechBubbleAppearance app = new SpeechBubbleAppearance(DEFAULT_APPEARANCE.getForeColor(), DEFAULT_APPEARANCE.getBackgroundColor1(), DEFAULT_APPEARANCE.getBorderColor(), DEFAULT_APPEARANCE.getPadding());
        return new SpeechBubble(entity, text, app, font);
    }

    public static SpeechBubble create(IEntity entity, Font font, String text, Sound typeSound) {
        SpeechBubbleAppearance app = new SpeechBubbleAppearance(DEFAULT_APPEARANCE.getForeColor(), DEFAULT_APPEARANCE.getBackgroundColor1(), DEFAULT_APPEARANCE.getBorderColor(), DEFAULT_APPEARANCE.getPadding());
        return new SpeechBubble(entity, text, typeSound, app, font);
    }

    public static boolean isActive(IEntity entity) {
        return activeSpeechBubbles.containsKey(entity);
    }

    @Override
    public IEntity getEntity() {
        return this.entity;
    }

    public SpeechBubbleAppearance getAppearance() {
        return this.appearance;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.displayedText == null || this.displayedText.isEmpty() || !Game.graphics().canRender(this.entity)) {
            return;
        }
        float deltaX = (float)((double)this.textBoxWidth / 2.0 + (double)this.getAppearance().getPadding());
        float deltaY = (float)((double)this.getEntity().getHeight() / 2.0 + (double)this.bubble.getHeight() + (double)this.getAppearance().getPadding() + 1.0);
        float startX = (float)(this.entityCenter.getX() - (double)deltaX);
        float startY = (float)(this.entityCenter.getY() - (double)deltaY);
        ImageRenderer.render(g, this.bubble, new Point2D.Double(startX, startY));
        g.setColor(this.getAppearance().getForeColor());
        FontRenderContext frc = g.getFontRenderContext();
        String text = this.displayedText;
        AttributedString styledText = new AttributedString(text);
        styledText.addAttribute(TextAttribute.FONT, this.getFont());
        AttributedCharacterIterator iterator = styledText.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
        measurer.setPosition(0);
        float y = startY + this.getAppearance().getPadding();
        float x = startX + this.getAppearance().getPadding();
        while (measurer.getPosition() < text.length()) {
            TextLayout layout = measurer.nextLayout(this.textBoxWidth);
            float dx = layout.isLeftToRight() ? 0.0f : this.textBoxWidth - layout.getAdvance();
            layout.draw(g, x + dx, y += layout.getAscent());
            y += layout.getDescent() + layout.getLeading();
        }
        if (Game.config().debug().renderGuiComponentBoundingBoxes()) {
            g.setColor(Color.RED);
            Game.graphics().renderOutline(g, new Rectangle2D.Double(this.getEntity().getCenter().getX() - (double)deltaX, this.getEntity().getCenter().getY() - (double)deltaY, this.bubble.getWidth(), this.bubble.getHeight()));
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void update() {
        if (this.currentText == null) {
            Game.world().environment().removeRenderable(this);
            Game.renderLoop().detach(this);
            if (activeSpeechBubbles.containsKey(this.getEntity()) && activeSpeechBubbles.get(this.getEntity()).equals(this)) {
                activeSpeechBubbles.remove(this.getEntity());
            }
            return;
        }
        this.entityCenter = Game.world().camera().getViewportLocation(this.getEntity().getCenter());
        if (this.lastTextDispay != 0L && Game.loop().getDeltaTime(this.lastTextDispay) > (long)this.currentTextDisplayTime) {
            this.currentText = null;
            this.displayedText = null;
            this.lastTextDispay = 0L;
            return;
        }
        if (!this.currentTextQueue.isEmpty() && Game.loop().getDeltaTime(this.lastCharPoll) > 30L) {
            this.displayedText = this.displayedText + this.currentTextQueue.poll();
            this.lastCharPoll = Game.loop().getTicks();
            if (this.typeSound != null) {
                Game.audio().playSound(this.getEntity(), this.typeSound);
            }
        }
    }

    private void cancel() {
        Game.world().environment().removeRenderable(this);
        Game.renderLoop().detach(this);
        if (activeSpeechBubbles.get(this.getEntity()) != null && activeSpeechBubbles.remove(this.getEntity()).equals(this)) {
            activeSpeechBubbles.remove(this.getEntity());
        }
    }

    private void createBubbleImage() {
        BufferedImage img = ImageProcessing.getCompatibleImage(500, 500);
        Graphics2D g = img.createGraphics();
        g.setFont(this.getFont());
        float stringWidth = g.getFontMetrics().stringWidth(this.currentText);
        if (stringWidth < this.textBoxWidth) {
            this.textBoxWidth = stringWidth;
        }
        FontRenderContext frc = g.getFontRenderContext();
        AttributedString styledText = new AttributedString(this.currentText);
        styledText.addAttribute(TextAttribute.FONT, this.getFont());
        AttributedCharacterIterator iterator = styledText.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
        measurer.setPosition(0);
        float y = 0.0f;
        while (measurer.getPosition() < this.currentText.length()) {
            TextLayout layout = measurer.nextLayout(this.textBoxWidth);
            y += layout.getAscent() + layout.getLeading() + layout.getDescent();
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, this.textBoxWidth + 2.0f * this.getAppearance().getPadding(), y + 2.0f * this.getAppearance().getPadding());
        Area ar = new Area(bounds);
        if (this.getAppearance().isRenderIndicator()) {
            GeneralPath path = new GeneralPath();
            path.moveTo(((RectangularShape)bounds).getWidth() / 2.0, ((RectangularShape)bounds).getHeight());
            path.lineTo(((RectangularShape)bounds).getWidth() / 2.0, ((RectangularShape)bounds).getHeight() + 6.0);
            path.lineTo(((RectangularShape)bounds).getWidth() / 2.0 + 6.0, ((RectangularShape)bounds).getHeight());
            path.closePath();
            ar.add(new Area(path));
        }
        int width = ar.getBounds().width;
        int height = ar.getBounds().height;
        g.setPaint(this.getAppearance().getBackgroundPaint(width, height));
        ShapeRenderer.render(g, ar);
        g.setColor(this.getAppearance().getBorderColor());
        ShapeRenderer.renderOutline(g, ar);
        g.dispose();
        this.bubble = ImageProcessing.crop(img, 1, 1, width + 1, height + 1);
    }
}

