/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.xml;

import de.gurkenlabs.litiengine.util.MathUtilities;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="param")
public class ParticleParameter
implements Serializable {
    public static final int MAX_VALUE_UNDEFINED = -1;
    private static final long serialVersionUID = 4893417265998349179L;
    @XmlAttribute
    private float maxValue;
    @XmlAttribute
    private float minValue;

    public ParticleParameter() {
    }

    public ParticleParameter(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public float get() {
        if (this.maxValue != -1.0f && this.minValue < this.maxValue) {
            return this.getRandomNumber();
        }
        return this.getMinValue();
    }

    @XmlTransient
    public float getMaxValue() {
        return this.maxValue;
    }

    @XmlTransient
    public float getMinValue() {
        return this.minValue;
    }

    @XmlTransient
    public float getRandomNumber() {
        return (float)MathUtilities.randomInRange(this.getMinValue(), this.getMaxValue());
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }
}

