/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class TextParticle
extends Particle {
    private Font font;
    private final String text;

    public TextParticle(String text, Color color, int ttl) {
        super(0.0f, 0.0f, color, ttl);
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void render(Graphics2D g, Point2D emitterOrigin) {
        if (this.getText() == null || this.getText().isEmpty()) {
            return;
        }
        Point2D renderLocation = this.getRenderLocation(emitterOrigin);
        g.setColor(this.getColor());
        Font oldFont = g.getFont();
        if (this.getFont() != null) {
            g.setFont(this.getFont());
        }
        FontMetrics fm = g.getFontMetrics();
        int x = fm.stringWidth(this.getText()) / 2;
        g.drawString(this.getText(), (float)renderLocation.getX() - (float)x, (float)renderLocation.getY());
        g.setFont(oldFont);
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

