/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;

public class SpriteParticle
extends Particle {
    private float angle;
    private final Image image;

    public SpriteParticle(Image sprite, int ttl) {
        super(0.0f, 0.0f, Color.WHITE, ttl);
        this.image = sprite;
    }

    public float getAngle() {
        return this.angle;
    }

    @Override
    public void render(Graphics2D g, Point2D emitterOrigin) {
        Point2D renderLocation = this.getRenderLocation(emitterOrigin);
        Composite oldComp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, this.getOpacity()));
        if (this.getAngle() != 0.0f) {
            ImageRenderer.renderRotated(g, this.image, renderLocation, this.getAngle());
        } else {
            ImageRenderer.render(g, this.image, renderLocation);
        }
        g.setComposite(oldComp);
    }

    public Particle setAngle(float angle) {
        this.angle = angle;
        return this;
    }
}

