/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.graphics.emitters.particles.RectangleFillParticle;
import java.awt.Color;
import java.awt.geom.Point2D;

public class LightParticle
extends RectangleFillParticle {
    private final float maxHeight;
    private final float maxWidth;
    private final float minHeight;
    private final float minWidth;

    public LightParticle(float maxWidth, float maxHeight, float width, float height, Color color, int life) {
        super(width, height, color, life);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.minWidth = width;
        this.minHeight = height;
    }

    @Override
    public void update(Point2D origin, float updateRatio) {
        super.update(origin, updateRatio);
        if ((double)Math.abs(this.maxWidth - this.getWidth()) < 0.1 || (double)Math.abs(this.getWidth() - this.minWidth) < 0.1) {
            this.setDeltaWidth(-this.getDeltaWidth());
        }
        if ((double)Math.abs(this.maxHeight - this.getHeight()) < 0.1 || (double)Math.abs(this.getHeight() - this.minHeight) < 0.1) {
            this.setDeltaHeight(-this.getDeltaHeight());
        }
    }
}

