/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.SpriteParticle;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.util.Random;

public abstract class SpritesheetEmitter
extends Emitter {
    private final Spritesheet spriteSheet;

    public SpritesheetEmitter(Spritesheet spriteSheet, Point2D origin) {
        super(origin);
        this.spriteSheet = spriteSheet;
        this.setSize(this.getSpritesheet().getSpriteWidth(), this.getSpritesheet().getSpriteHeight());
    }

    public Spritesheet getSpritesheet() {
        return this.spriteSheet;
    }

    protected Image getRandomSprite() {
        return this.getSpritesheet().getSprite(new Random().nextInt(this.getSpritesheet().getTotalNumberOfSprites()));
    }

    @Override
    protected Particle createNewParticle() {
        return new SpriteParticle(this.getRandomSprite(), this.getRandomParticleTTL());
    }
}

