/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ITimeToLive;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.annotation.CollisionInfo;
import de.gurkenlabs.litiengine.annotation.EmitterInfo;
import de.gurkenlabs.litiengine.configuration.Quality;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@CollisionInfo(collision=false)
@EmitterInfo
public abstract class Emitter
extends Entity
implements IUpdateable,
ITimeToLive,
IRenderable {
    public static final Color DEFAULT_PARTICLE_COLOR = new Color(255, 255, 255, 150);
    public static final int DEFAULT_UPDATERATE = 30;
    public static final int DEFAULT_SPAWNAMOUNT = 1;
    public static final int DEFAULT_MAXPARTICLES = 100;
    private static final Random RANDOM = new Random();
    private final List<Consumer<Emitter>> finishedConsumer;
    private final CopyOnWriteArrayList<Particle> particles;
    private final List<Color> colors = new ArrayList<Color>();
    private Quality requiredQuality;
    private boolean activateOnInit;
    private boolean activated;
    private boolean paused;
    private boolean stopped;
    private long activationTick;
    private long aliveTime;
    private long lastSpawn;
    private int maxParticles;
    private int particleMaxTTL;
    private int particleMinTTL;
    private int particleUpdateDelay;
    private int spawnAmount;
    private int spawnRate;
    private int timeToLive;
    private Valign originValign;
    private Align originAlign;
    private Map<RenderType, IRenderable> renderables;

    public Emitter() {
        this.finishedConsumer = new CopyOnWriteArrayList<Consumer<Emitter>>();
        this.particles = new CopyOnWriteArrayList();
        this.renderables = new ConcurrentHashMap<RenderType, IRenderable>();
        for (RenderType type : RenderType.values()) {
            if (type == RenderType.NONE) continue;
            this.renderables.put(type, g -> this.renderParticles(g, type));
        }
        EmitterInfo info = this.getClass().getAnnotation(EmitterInfo.class);
        if (info != null) {
            this.requiredQuality = info.requiredQuality();
            this.maxParticles = info.maxParticles();
            this.spawnAmount = info.spawnAmount();
            this.spawnRate = info.spawnRate();
            this.timeToLive = info.emitterTTL();
            this.particleMinTTL = info.particleMinTTL();
            this.particleMaxTTL = info.particleMaxTTL();
            this.particleUpdateDelay = info.particleUpdateRate();
            this.activateOnInit = info.activateOnInit();
            this.originAlign = info.originAlign();
            this.originValign = info.originVAlign();
        }
    }

    public Emitter(double originX, double originY) {
        this(new Point2D.Double(originX, originY));
    }

    public Emitter(Point2D origin) {
        this();
        this.setLocation(origin);
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.activated = true;
        this.activationTick = Game.loop().getTicks();
        Game.loop().attach(this);
    }

    public void addParticle(Particle particle) {
        if (this.isStopped()) {
            return;
        }
        this.particles.add(particle);
    }

    public void deactivate() {
        if (!this.activated) {
            return;
        }
        this.activated = false;
        this.getParticles().clear();
        this.aliveTime = 0L;
        this.activationTick = 0L;
        this.lastSpawn = 0L;
        Game.loop().detach(this);
    }

    public void delete() {
        this.deactivate();
        if (Game.world().environment() != null) {
            Game.world().environment().remove(this);
        }
    }

    @Override
    public long getAliveTime() {
        return this.aliveTime;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this.getX() + this.getOriginAlign().getValue(this.getWidth()), this.getY() + this.getOriginValign().getValue(this.getHeight()));
    }

    public Align getOriginAlign() {
        return this.originAlign;
    }

    public Valign getOriginValign() {
        return this.originValign;
    }

    public IRenderable getRenderable(RenderType type) {
        if (type == RenderType.NONE) {
            return null;
        }
        return this.renderables.get((Object)type);
    }

    public int getMaxParticles() {
        return this.maxParticles;
    }

    public int getParticleMaxTTL() {
        return this.particleMaxTTL;
    }

    public int getParticleMinTTL() {
        return this.particleMinTTL;
    }

    public void getParticleMinTTL(int minTTL) {
        this.particleMinTTL = minTTL;
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public int getParticleUpdateRate() {
        return this.particleUpdateDelay;
    }

    public Quality getRequiredQuality() {
        return this.requiredQuality;
    }

    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    public int getSpawnRate() {
        return this.spawnRate;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isActivateOnInit() {
        return this.activateOnInit;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isFinished() {
        return this.getTimeToLive() > 0 && this.timeToLiveReached() || this.activated && this.lastSpawn > 0L && this.getParticles().isEmpty();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void onFinished(Consumer<Emitter> cons) {
        this.finishedConsumer.add(cons);
    }

    @Override
    public void render(Graphics2D g) {
        this.renderParticles(g, RenderType.NONE);
        if (Game.config().debug().renderHitBoxes()) {
            DebugRenderer.renderEntityDebugInfo(g, this);
        }
    }

    public void setColors(Color ... colors) {
        this.colors.clear();
        this.colors.addAll(Arrays.asList(colors));
    }

    public void setMaxParticles(int maxPart) {
        this.maxParticles = maxPart;
    }

    public void setOriginAlign(Align align) {
        this.originAlign = align;
    }

    public void setOriginValign(Valign valign) {
        this.originValign = valign;
    }

    public void setParticleMaxTTL(int maxTTL) {
        this.particleMaxTTL = maxTTL;
    }

    public void setParticleMinTTL(int minTTL) {
        this.particleMinTTL = minTTL;
    }

    public void setParticleUpdateRate(int delay) {
        this.particleUpdateDelay = delay;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void setRequiredQuality(Quality requiredQuality) {
        this.requiredQuality = requiredQuality;
    }

    public void setSpawnAmount(int spawnAmount) {
        this.spawnAmount = spawnAmount;
    }

    public void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    @Override
    public boolean timeToLiveReached() {
        return this.activated && this.getTimeToLive() > 0 && this.getAliveTime() >= (long)this.getTimeToLive();
    }

    public void togglePaused() {
        this.paused = !this.paused;
    }

    public void toggleStopped() {
        this.stopped = !this.stopped;
    }

    @Override
    public void update() {
        if (this.isPaused()) {
            return;
        }
        if (this.isFinished()) {
            for (Consumer<Emitter> cons : this.finishedConsumer) {
                cons.accept(this);
            }
            this.delete();
            return;
        }
        float updateRatio = (float)this.getParticleUpdateRate() / (float)Game.loop().getUpdateRate();
        for (Particle p : this.getParticles().stream().collect(Collectors.toList())) {
            if (this.particleCanBeRemoved(p)) {
                this.particles.remove(p);
                continue;
            }
            p.update(this.getOrigin(), updateRatio);
        }
        this.aliveTime = Game.loop().getDeltaTime(this.activationTick);
        if (this.getSpawnRate() == 0 || Game.loop().getDeltaTime(this.lastSpawn) >= (long)this.getSpawnRate()) {
            this.spawnParticle();
        }
    }

    protected void addParticleColor(Color ... colors) {
        for (Color color : colors) {
            if (this.colors.contains(color)) continue;
            this.colors.add(color);
        }
    }

    protected boolean canTakeNewParticles() {
        return this.particles.size() < this.maxParticles;
    }

    protected abstract Particle createNewParticle();

    protected Color getRandomParticleColor() {
        if (this.colors.isEmpty()) {
            return DEFAULT_PARTICLE_COLOR;
        }
        return this.colors.get(RANDOM.nextInt(this.colors.size()));
    }

    protected int getRandomParticleTTL() {
        if (this.getParticleMaxTTL() == 0) {
            return this.getParticleMinTTL();
        }
        int ttlDiff = this.getParticleMaxTTL() - this.getParticleMinTTL();
        if (ttlDiff <= 0) {
            return this.getParticleMaxTTL();
        }
        return RANDOM.nextInt(this.getParticleMaxTTL() - this.getParticleMinTTL()) + this.getParticleMinTTL();
    }

    protected int getRandomParticleX() {
        return RANDOM.nextInt((int)this.getWidth());
    }

    protected int getRandomParticleY() {
        return RANDOM.nextInt((int)this.getHeight());
    }

    protected boolean particleCanBeRemoved(Particle particle) {
        return particle.timeToLiveReached();
    }

    protected void spawnParticle() {
        for (int i = 0; i < this.getSpawnAmount(); i = (int)((short)(i + 1))) {
            if (!this.canTakeNewParticles()) {
                return;
            }
            Particle part = this.createNewParticle();
            if (part == null) continue;
            this.addParticle(part);
        }
    }

    private void renderParticles(Graphics2D g, RenderType renderType) {
        if (Game.config().graphics().getGraphicQuality().getValue() < this.getRequiredQuality().getValue()) {
            return;
        }
        if (Game.screens() != null && Game.world().camera() != null && !Game.world().camera().getViewport().intersects(this.getBoundingBox())) {
            return;
        }
        Point2D origin = this.getOrigin();
        for (Particle particle : this.particles) {
            if ((particle.usesCustomRenderType() || renderType != RenderType.NONE) && (!particle.usesCustomRenderType() || particle.getCustomRenderType() != renderType)) continue;
            particle.render(g, origin);
        }
    }
}

