/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.PropState;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class PropAnimationController<T extends Prop>
extends EntityAnimationController<T> {
    private static final String DAMAGED = "damaged";
    private static final String DESTROYED = "destroyed";
    private static final String INTACT = "intact";

    public PropAnimationController(T prop) {
        super(prop);
        this.setDefaultAnimation(this.createAnimation((Prop)this.getEntity(), PropState.INTACT));
        this.add(this.createAnimation((Prop)this.getEntity(), PropState.DAMAGED));
        this.add(this.createAnimation((Prop)this.getEntity(), PropState.DESTROYED));
    }

    @Override
    public BufferedImage getCurrentSprite() {
        Animation animation = this.getCurrentAnimation();
        if (animation == null || animation.getSpritesheet() == null) {
            return null;
        }
        String cacheKey = this.buildCurrentCacheKey();
        cacheKey = cacheKey + "_" + ((Prop)this.getEntity()).isAddShadow();
        cacheKey = cacheKey + "_" + (Object)((Object)((Prop)this.getEntity()).getState());
        cacheKey = cacheKey + "_" + (Object)((Object)((Prop)this.getEntity()).getSpriteRotation());
        cacheKey = cacheKey + "_" + ((Prop)this.getEntity()).flipHorizontally();
        cacheKey = cacheKey + "_" + ((Prop)this.getEntity()).flipVertically();
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            return (BufferedImage)opt.get();
        }
        BufferedImage currentImage = super.getCurrentSprite();
        if (currentImage == null) {
            return null;
        }
        if (((Prop)this.getEntity()).getSpriteRotation() != Rotation.NONE) {
            currentImage = ImageProcessing.rotate(currentImage, ((Prop)this.getEntity()).getSpriteRotation());
        }
        if (((Prop)this.getEntity()).flipHorizontally()) {
            currentImage = ImageProcessing.horizontalFlip(currentImage);
        }
        if (((Prop)this.getEntity()).flipVertically()) {
            currentImage = ImageProcessing.verticalFlip(currentImage);
        }
        if (!((Prop)this.getEntity()).isAddShadow()) {
            return currentImage;
        }
        int ShadowYOffset = currentImage.getHeight();
        BufferedImage shadow = ImageProcessing.addShadow(currentImage, 0, ShadowYOffset);
        Resources.images().add(cacheKey, shadow);
        return shadow;
    }

    @Override
    public void update() {
        super.update();
        switch (((Prop)this.getEntity()).getState()) {
            case DAMAGED: {
                this.playAnimation(DAMAGED);
                break;
            }
            case DESTROYED: {
                this.playAnimation(DESTROYED);
                break;
            }
            default: {
                this.playAnimation(INTACT);
            }
        }
    }

    @Override
    public boolean isAutoScaling() {
        return ((Prop)this.getEntity()).isScaling();
    }

    private Animation createAnimation(Prop prop, PropState state) {
        Spritesheet spritesheet = this.findSpriteSheet(prop, state);
        if (spritesheet == null) {
            return null;
        }
        return new Animation(state.name(), spritesheet, true, true, Resources.spritesheets().getCustomKeyFrameDurations(spritesheet.getName()));
    }

    private Spritesheet findSpriteSheet(Prop prop, PropState state) {
        if (prop == null || prop.getSpritesheetName() == null || prop.getSpritesheetName().isEmpty()) {
            return null;
        }
        String propState = state.name().toLowerCase();
        String name = "prop-" + prop.getSpritesheetName().toLowerCase() + "-" + propState;
        Optional opt = Resources.spritesheets().tryGet(name);
        if (opt.isPresent()) {
            return (Spritesheet)opt.get();
        }
        String fallbackName = "prop-" + prop.getSpritesheetName().toLowerCase();
        return Resources.spritesheets().get(fallbackName);
    }
}

