/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.AnimationInfo;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.AnimationController;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;

public class EntityAnimationController<T extends IEntity>
extends AnimationController
implements IEntityAnimationController {
    private final List<AnimationRule> animationRules = new CopyOnWriteArrayList<AnimationRule>();
    private final T entity;
    private String spritePrefix;
    private boolean autoScaling;

    public EntityAnimationController(T entity) {
        this.entity = entity;
        if (entity != null) {
            this.spritePrefix = ArrayUtilities.getRandom(EntityAnimationController.getDefaultSpritePrefixes(entity.getClass()));
        }
    }

    public EntityAnimationController(T entity, Animation defaultAnimation, Animation ... animations) {
        super(defaultAnimation, animations);
        this.entity = entity;
        this.spritePrefix = ArrayUtilities.getRandom(EntityAnimationController.getDefaultSpritePrefixes(entity.getClass()));
    }

    public EntityAnimationController(T entity, Spritesheet sprite) {
        this(entity, sprite, true);
    }

    public EntityAnimationController(T entity, Spritesheet sprite, boolean loop) {
        this(entity, new Animation(sprite, loop, Resources.spritesheets().getCustomKeyFrameDurations(sprite)), new Animation[0]);
    }

    public static <T> String[] getDefaultSpritePrefixes(Class<T> cls) {
        AnimationInfo animationInfo = cls.getAnnotation(AnimationInfo.class);
        if (animationInfo != null && animationInfo.spritePrefix().length > 0) {
            return animationInfo.spritePrefix();
        }
        return new String[]{cls.getSimpleName().toLowerCase()};
    }

    @Override
    public void addAnimationRule(Predicate<IEntity> rule, Function<IEntity, String> animationName) {
        this.animationRules.add(new AnimationRule(rule, animationName));
    }

    public T getEntity() {
        return this.entity;
    }

    @Override
    public void update() {
        super.update();
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return;
        }
        if (this.getCurrentAnimation() != null && !this.getCurrentAnimation().isLoop() && this.getCurrentAnimation().isPlaying()) {
            return;
        }
        if (this.getEntity() == null) {
            return;
        }
        for (AnimationRule animationRule : this.animationRules) {
            if (!animationRule.getCondition().test((IEntity)this.getEntity())) continue;
            String animationName = animationRule.getAnimationName().apply((IEntity)this.getEntity());
            if (this.getCurrentAnimation() != null && (animationName == null || animationName.isEmpty() || this.getCurrentAnimation().getName().equalsIgnoreCase(animationName))) break;
            this.playAnimation(animationName);
            break;
        }
    }

    protected String getSpritePrefix() {
        return this.spritePrefix;
    }

    protected void setSpritePrefix(String prefix) {
        this.spritePrefix = prefix;
    }

    @Override
    public boolean isAutoScaling() {
        return this.autoScaling;
    }

    @Override
    public void setAutoScaling(boolean scaling) {
        this.autoScaling = scaling;
    }

    @Override
    public void scaleSprite(float scaleX, float scaleY) {
        Point2D point = Game.world().camera().getViewportLocation((IEntity)this.getEntity());
        double deltaX = point.getX() - point.getX() * (double)scaleX;
        double deltaY = point.getY() - point.getY() * (double)scaleY;
        BufferedImage img = this.getCurrentSprite();
        if (img != null) {
            double imgDeltaX = (double)((float)img.getWidth() - (float)img.getWidth() * scaleX) / 2.0;
            double imgDeltaY = (double)((float)img.getHeight() - (float)img.getHeight() * scaleY) / 2.0;
            deltaX += imgDeltaX;
            deltaY += imgDeltaY;
        }
        AffineTransform trans = new AffineTransform();
        trans.translate(deltaX, deltaY);
        trans.scale(scaleX, scaleY);
        this.setAffineTransform(trans);
    }

    @Override
    public void scaleSprite(float scale) {
        this.scaleSprite(scale, scale);
    }

    protected class AnimationRule {
        private final Predicate<IEntity> condition;
        private final Function<IEntity, String> animationName;

        AnimationRule(Predicate<IEntity> condition, Function<IEntity, String> animationName) {
            this.condition = condition;
            this.animationName = animationName;
        }

        Predicate<IEntity> getCondition() {
            return this.condition;
        }

        Function<IEntity, String> getAnimationName() {
            return this.animationName;
        }
    }
}

