/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.annotation.AnimationInfo;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class CreatureAnimationController<T extends Creature>
extends EntityAnimationController<T> {
    public static final String IDLE = "-idle";
    public static final String WALK = "-walk";
    public static final String DEAD = "-dead";
    private String[] customDeathAnimations;
    private String randomDeathSprite;

    public CreatureAnimationController(T entity, boolean useFlippedSpritesAsFallback) {
        super(entity);
        this.init(useFlippedSpritesAsFallback);
    }

    public CreatureAnimationController(T entity, Animation defaultAnimation) {
        this(entity, true, defaultAnimation, new Animation[0]);
    }

    public CreatureAnimationController(T entity, boolean useFlippedSpritesAsFallback, Animation defaultAnimation, Animation ... animations) {
        super(entity, defaultAnimation, animations);
        this.init(useFlippedSpritesAsFallback);
    }

    @Override
    protected String getSpritePrefix() {
        return ((Creature)this.getEntity()).getSpritePrefix();
    }

    protected String getCurrentAnimationName() {
        if (((Creature)this.getEntity()).isDead()) {
            return this.getDeathAnimationName();
        }
        if (((Creature)this.getEntity()).isIdle()) {
            String idleName = this.getIdleSpriteName(((Creature)this.getEntity()).getFacingDirection());
            if (this.hasAnimation(idleName)) {
                return idleName;
            }
            return this.getWalkSpriteName(((Creature)this.getEntity()).getFacingDirection());
        }
        String walkName = this.getWalkSpriteName(((Creature)this.getEntity()).getFacingDirection());
        if (this.hasAnimation(walkName)) {
            return walkName;
        }
        return this.getIdleSpriteName(((Creature)this.getEntity()).getFacingDirection());
    }

    private String getDeathAnimationName() {
        String deadName;
        if (this.customDeathAnimations.length > 0) {
            String randomDeathAnmimation;
            if (this.randomDeathSprite != null) {
                return this.randomDeathSprite;
            }
            String randomDeathAnim = ArrayUtilities.getRandom(this.customDeathAnimations);
            if (randomDeathAnim != null && !randomDeathAnim.isEmpty() && this.hasAnimation(randomDeathAnmimation = this.getSpritePrefix() + "-" + randomDeathAnim)) {
                this.randomDeathSprite = randomDeathAnmimation;
                return this.randomDeathSprite;
            }
        }
        if (this.hasAnimation(deadName = this.getSpritePrefix() + DEAD)) {
            return deadName;
        }
        return null;
    }

    private void initializeAvailableAnimations() {
        Spritesheet baseWalk;
        Spritesheet baseIdle;
        for (Direction dir : Direction.values()) {
            Spritesheet idleSprite;
            Spritesheet walkSprite = Resources.spritesheets().get(this.getSpriteName(WALK) + "-" + dir.toString().toLowerCase());
            if (walkSprite != null) {
                this.add(new Animation(walkSprite, true, new int[0]));
            }
            if ((idleSprite = Resources.spritesheets().get(this.getSpriteName(IDLE) + "-" + dir.toString().toLowerCase())) == null) continue;
            this.add(new Animation(idleSprite, true, new int[0]));
        }
        Spritesheet deadSprite = Resources.spritesheets().get(this.getSpritePrefix() + DEAD);
        if (deadSprite != null) {
            this.add(new Animation(deadSprite, true, new int[0]));
        }
        if ((baseIdle = Resources.spritesheets().get(this.getSpriteName(IDLE))) != null) {
            this.add(new Animation(baseIdle, true, new int[0]));
        }
        if ((baseWalk = Resources.spritesheets().get(this.getSpriteName(WALK))) != null) {
            this.add(new Animation(baseWalk, true, new int[0]));
        }
    }

    private void initializeFlippedAnimations() {
        String leftIdle = this.getSpriteName(IDLE) + "-left";
        String leftWalk = this.getSpriteName(WALK) + "-left";
        Optional<Animation> leftIdleAnimation = this.getAnimations().stream().filter(x -> x.getName().equals(leftIdle)).findFirst();
        Optional<Animation> leftWalkAnimation = this.getAnimations().stream().filter(x -> x.getName().equals(leftWalk)).findFirst();
        String rightIdle = this.getSpriteName(IDLE) + "-right";
        String rightWalk = this.getSpriteName(WALK) + "-right";
        Optional<Animation> rightIdleAnimation = this.getAnimations().stream().filter(x -> x.getName().equals(rightIdle)).findFirst();
        Optional<Animation> rightWalkAnimation = this.getAnimations().stream().filter(x -> x.getName().equals(rightWalk)).findFirst();
        if (!leftIdleAnimation.isPresent() && rightIdleAnimation.isPresent()) {
            this.add(this.flipAnimation(rightIdleAnimation.get().getSpritesheet(), leftIdle));
        }
        if (!leftWalkAnimation.isPresent() && rightWalkAnimation.isPresent()) {
            this.add(this.flipAnimation(rightWalkAnimation.get().getSpritesheet(), leftWalk));
        }
        if (!rightIdleAnimation.isPresent() && leftIdleAnimation.isPresent()) {
            this.add(this.flipAnimation(leftIdleAnimation.get().getSpritesheet(), rightIdle));
        }
        if (!rightWalkAnimation.isPresent() && leftWalkAnimation.isPresent()) {
            this.add(this.flipAnimation(leftWalkAnimation.get().getSpritesheet(), rightWalk));
        }
    }

    public Animation flipAnimation(Spritesheet spriteToFlip, String newSpriteName) {
        BufferedImage leftIdleSprite = ImageProcessing.flipSpritesHorizontally(spriteToFlip);
        Spritesheet leftIdleSpritesheet = Resources.spritesheets().load(leftIdleSprite, newSpriteName, spriteToFlip.getSpriteWidth(), spriteToFlip.getSpriteHeight());
        return new Animation(leftIdleSpritesheet, true, new int[0]);
    }

    private String getIdleSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(IDLE, dir);
    }

    private String getWalkSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(WALK, dir);
    }

    private String getSpriteNameWithDirection(String state, Direction dir) {
        String name = this.getSpriteName(state) + "-" + dir.toString().toLowerCase();
        if (this.hasAnimation(name)) {
            return name;
        }
        return this.getFallbackSpriteName(state, dir);
    }

    private static String getOppositeState(String state) {
        return state.equalsIgnoreCase(IDLE) ? WALK : IDLE;
    }

    private String getFallbackSpriteName(String state, Direction dir) {
        String fallbackStateName = this.getSpriteName(CreatureAnimationController.getOppositeState(state)) + "-" + dir.toString().toLowerCase();
        if (this.hasAnimation(fallbackStateName)) {
            return fallbackStateName;
        }
        String baseName = this.getSpriteName(state);
        if (this.hasAnimation(baseName)) {
            return baseName;
        }
        for (Direction d : Direction.values()) {
            String name = this.getSpriteName(state) + "-" + d.toString().toLowerCase();
            if (!this.hasAnimation(name)) continue;
            return name;
        }
        return this.getDefaultAnimation() != null ? this.getDefaultAnimation().getName() : null;
    }

    private String getSpriteName(String state) {
        return this.getSpritePrefix() + state;
    }

    private void init(boolean useFlippedSpritesAsFallback) {
        this.initializeAvailableAnimations();
        if (useFlippedSpritesAsFallback) {
            this.initializeFlippedAnimations();
        }
        this.addAnimationRule(e -> true, e -> this.getCurrentAnimationName());
        AnimationInfo info = ((Creature)this.getEntity()).getClass().getAnnotation(AnimationInfo.class);
        this.customDeathAnimations = info != null ? info.deathAnimations() : new String[0];
    }
}

