/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.KeyFrame;
import de.gurkenlabs.litiengine.resources.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Animation
implements IUpdateable,
ILaunchable {
    public static final int DEFAULT_FRAME_DURATION = 120;
    private static final Logger log = Logger.getLogger(Animation.class.getName());
    private KeyFrame currentFrame;
    private long elapsedTicks;
    private KeyFrame firstFrame;
    private int frameDuration = 120;
    private final List<KeyFrame> keyframes;
    private final boolean loop;
    private final String name;
    private boolean paused;
    private boolean playing;
    private Spritesheet spritesheet;

    public Animation(String spriteSheetName, boolean loop, boolean randomizeStart, int ... keyFrameDurations) {
        this(Resources.spritesheets().get(spriteSheetName), loop, randomizeStart, keyFrameDurations);
    }

    public Animation(Spritesheet spritesheet, boolean loop, boolean randomizeStart, int ... keyFrameDurations) {
        this(spritesheet.getName(), spritesheet, loop, randomizeStart, keyFrameDurations);
    }

    public Animation(Spritesheet spritesheet, boolean loop, int ... keyFrameDurations) {
        this(spritesheet.getName(), spritesheet, loop, keyFrameDurations);
    }

    public Animation(String name, Spritesheet spritesheet, boolean loop, boolean randomizeStart, int ... keyFrameDurations) {
        this(name, spritesheet, loop, keyFrameDurations);
        if (randomizeStart && !this.keyframes.isEmpty()) {
            this.firstFrame = this.getKeyframes().get(new Random().nextInt(this.getKeyframes().size()));
        }
    }

    public Animation(String name, Spritesheet spritesheet, boolean loop, int ... keyFrameDurations) {
        this.name = name;
        this.spritesheet = spritesheet;
        this.loop = loop;
        this.keyframes = new ArrayList<KeyFrame>();
        if (spritesheet == null) {
            log.log(Level.WARNING, "no spritesheet defined for animation {0}", this.getName());
            return;
        }
        this.initKeyFrames(keyFrameDurations);
        if (this.getKeyframes().isEmpty()) {
            log.log(Level.WARNING, "No keyframes defined for animation " + this.getName() + " (spitesheet: {0})", spritesheet.getName());
        }
    }

    public KeyFrame getCurrentKeyFrame() {
        return this.currentFrame;
    }

    public List<KeyFrame> getKeyframes() {
        return this.keyframes;
    }

    public int getTotalDuration() {
        int duration = 0;
        for (KeyFrame keyFrame : this.getKeyframes()) {
            duration += keyFrame.getDuration();
        }
        return duration;
    }

    public String getName() {
        return this.name;
    }

    public Spritesheet getSpritesheet() {
        if (this.spritesheet != null && !this.spritesheet.isLoaded()) {
            this.spritesheet = Resources.spritesheets().get(this.spritesheet.getName());
            this.initKeyFrames(new int[0]);
        }
        return this.spritesheet;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPlaying() {
        return !this.paused && !this.keyframes.isEmpty() && this.playing;
    }

    public void pause() {
        this.paused = true;
    }

    public void setFrameDuration(int frameDuration) {
        this.frameDuration = frameDuration;
        for (KeyFrame keyFrame : this.getKeyframes()) {
            keyFrame.setDuration(this.frameDuration);
        }
    }

    public void setkeyFrameDurations(int ... keyFrameDurations) {
        if (keyFrameDurations.length == 0) {
            return;
        }
        for (int i = 0; i < this.getKeyframes().size(); ++i) {
            this.getKeyframes().get(i).setDuration(keyFrameDurations[i]);
        }
    }

    @Override
    public void start() {
        this.elapsedTicks = 0L;
        this.playing = true;
        if (this.getKeyframes().isEmpty()) {
            return;
        }
        this.currentFrame = this.firstFrame;
        Game.loop().attach(this);
    }

    public void restart() {
        this.currentFrame = this.firstFrame;
    }

    @Override
    public void terminate() {
        this.elapsedTicks = 0L;
        this.playing = false;
        if (this.getKeyframes().isEmpty()) {
            return;
        }
        this.currentFrame = this.getKeyframes().get(0);
    }

    public void unpause() {
        this.paused = false;
    }

    @Override
    public void update() {
        if (!this.isPlaying() || Game.loop().convertToMs(++this.elapsedTicks) < (long)this.currentFrame.getDuration()) {
            return;
        }
        if (!this.isLoop() && this.isLastKeyFrame()) {
            this.terminate();
            return;
        }
        int newFrameIndex = (this.getKeyframes().indexOf(this.currentFrame) + 1) % this.getKeyframes().size();
        this.currentFrame = this.getKeyframes().get(newFrameIndex);
        this.elapsedTicks = 0L;
    }

    private void initKeyFrames(int ... keyFrames) {
        if (this.getSpritesheet() == null) {
            return;
        }
        this.keyframes.clear();
        int[] keyFrameDurations = keyFrames;
        if (keyFrameDurations.length == 0) {
            keyFrameDurations = Resources.spritesheets().getCustomKeyFrameDurations(this.name);
        }
        if (keyFrameDurations.length == 0) {
            for (int i = 0; i < this.getSpritesheet().getTotalNumberOfSprites(); ++i) {
                this.keyframes.add(i, new KeyFrame(this.frameDuration, i));
            }
        } else {
            for (int i = 0; i < keyFrameDurations.length; ++i) {
                this.keyframes.add(i, new KeyFrame(keyFrameDurations[i], i));
            }
        }
        if (!this.keyframes.isEmpty()) {
            this.firstFrame = this.getKeyframes().get(0);
        }
    }

    private boolean isLastKeyFrame() {
        return this.getKeyframes().indexOf(this.currentFrame) == this.getKeyframes().size() - 1;
    }
}

