/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.gui.GuiProperties;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public final class TextRenderer {
    private TextRenderer() {
        throw new UnsupportedOperationException();
    }

    public static void render(Graphics2D g, String text, double x, double y) {
        TextRenderer.render(g, text, x, y, GuiProperties.getDefaultAppearance().getTextAntialiasing());
    }

    public static void render(Graphics2D g, String text, Point2D location) {
        TextRenderer.render(g, text, location.getX(), location.getY());
    }

    public static void render(Graphics2D g, String text, double x, double y, Object antiAliasing) {
        if (text == null || text.isEmpty()) {
            return;
        }
        RenderingHints originalHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antiAliasing);
        g.drawString(text, (float)x, (float)y);
        g.setRenderingHints(originalHints);
    }

    public static void render(Graphics2D g, String text, Point2D location, Object antiAliasing) {
        TextRenderer.render(g, text, location.getX(), location.getY(), antiAliasing);
    }

    public static void renderRotated(Graphics2D g, String text, double x, double y, double angle, Object antiAliasing) {
        RenderingHints originalHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antiAliasing);
        TextRenderer.renderRotated(g, text, x, y, angle);
        g.setRenderingHints(originalHints);
    }

    public static void renderRotated(Graphics2D g, String text, double x, double y, double angle) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.rotate(Math.toRadians(angle), x, y);
        TextRenderer.render(g2, text, x, y);
        g2.dispose();
    }

    public static void renderRotated(Graphics2D g, String text, Point2D location, double angle) {
        TextRenderer.renderRotated(g, text, location.getX(), location.getY(), angle);
    }

    public static void renderRotated(Graphics2D g, String text, Point2D location, double angle, Object antiAliasing) {
        TextRenderer.renderRotated(g, text, location.getX(), location.getY(), angle, antiAliasing);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, double x, double y, double lineWidth) {
        TextRenderer.renderWithLinebreaks(g, text, x, y, lineWidth, GuiProperties.getDefaultAppearance().getTextAntialiasing());
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, Point2D location, double lineWidth) {
        TextRenderer.renderWithLinebreaks(g, text, location.getX(), location.getY(), lineWidth);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, double x, double y, double lineWidth, Object antiAliasing) {
        if (text == null || text.isEmpty()) {
            return;
        }
        RenderingHints originalHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antiAliasing);
        FontRenderContext frc = g.getFontRenderContext();
        AttributedString styledText = new AttributedString(text);
        styledText.addAttribute(TextAttribute.FONT, g.getFont());
        AttributedCharacterIterator iterator = styledText.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, frc);
        measurer.setPosition(0);
        float textY = (float)y;
        while (measurer.getPosition() < text.length()) {
            TextLayout nextLayout = measurer.nextLayout((float)lineWidth);
            float dx = (float)(nextLayout.isLeftToRight() ? 0.0 : lineWidth - (double)nextLayout.getAdvance());
            nextLayout.draw(g, (float)(x + (double)dx), textY += nextLayout.getAscent());
            textY += nextLayout.getDescent() + nextLayout.getLeading();
        }
        g.setRenderingHints(originalHints);
    }

    public static void renderWithLinebreaks(Graphics2D g, String text, Point2D location, double lineWidth, Object antiAliasing) {
        TextRenderer.renderWithLinebreaks(g, text, location.getX(), location.getY(), lineWidth, antiAliasing);
    }

    public static void renderWithOutline(Graphics2D g, String text, double x, double y, Color outlineColor) {
        TextRenderer.renderWithOutline(g, text, x, y, outlineColor, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void renderWithOutline(Graphics2D g, String text, Point2D location, Color outlineColor) {
        TextRenderer.renderWithOutline(g, text, location.getX(), location.getY(), outlineColor);
    }

    public static void renderWithOutline(Graphics2D g, String text, double x, double y, Color outlineColor, Object antiAliasing) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Color fillColor = g.getColor();
        BasicStroke outlineStroke = new BasicStroke((float)(g.getFont().getSize() * 1) / 10.0f);
        Color originalColor = g.getColor();
        Stroke originalStroke = g.getStroke();
        RenderingHints originalHints = g.getRenderingHints();
        GlyphVector glyphVector = g.getFont().createGlyphVector(g.getFontRenderContext(), text);
        AffineTransform at = new AffineTransform();
        at.translate(x, y);
        Shape textShape = at.createTransformedShape(glyphVector.getOutline());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAliasing);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(outlineColor);
        g.setStroke(outlineStroke);
        g.draw(textShape);
        g.setColor(fillColor);
        g.fill(textShape);
        g.setColor(originalColor);
        g.setStroke(originalStroke);
        g.setRenderingHints(originalHints);
    }

    public static void renderWithOutline(Graphics2D g, String text, Point2D location, Color outlineColor, Object antiAliasing) {
        TextRenderer.renderWithOutline(g, text, location.getX(), location.getY(), outlineColor, antiAliasing);
    }
}

