/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class StaticShadowLayer
extends ColorLayer {
    public StaticShadowLayer(IEnvironment env, Color color) {
        super(env, color);
    }

    @Override
    protected void renderSection(Graphics2D g, Rectangle2D section) {
        Color color = this.getColor();
        g.setColor(color);
        Area ar = new Area();
        for (StaticShadow staticShadow : this.getEnvironment().getStaticShadows()) {
            if (!staticShadow.getBoundingBox().intersects(section) || staticShadow.getShadowType() == StaticShadowType.NONE) continue;
            Area staticShadowArea = staticShadow.getArea();
            ar.add(staticShadowArea);
        }
        ar.transform(AffineTransform.getTranslateInstance(-section.getX(), -section.getY()));
        g.fill(ar);
    }
}

