/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.io.File;
import java.util.ArrayList;

public enum ImageFormat {
    UNDEFINED,
    PNG,
    GIF,
    BMP,
    JPG;


    public static ImageFormat get(String imageFormat) {
        if (imageFormat == null || imageFormat.isEmpty()) {
            return UNDEFINED;
        }
        String stripedImageFormat = imageFormat;
        if (stripedImageFormat.startsWith(".")) {
            stripedImageFormat = imageFormat.substring(1);
        }
        for (ImageFormat val : ImageFormat.values()) {
            if (!stripedImageFormat.equalsIgnoreCase(val.toString())) continue;
            return val;
        }
        return UNDEFINED;
    }

    public static boolean isSupported(File file) {
        return ImageFormat.isSupported(file.getAbsolutePath());
    }

    public static boolean isSupported(String fileName) {
        String extension = FileUtilities.getExtension(fileName);
        if (extension == null || extension.isEmpty()) {
            return false;
        }
        for (String supported : ImageFormat.getAllExtensions()) {
            if (!extension.equalsIgnoreCase(supported)) continue;
            return true;
        }
        return false;
    }

    public static String[] getAllExtensions() {
        ArrayList<String> arrList = new ArrayList<String>();
        for (ImageFormat format : ImageFormat.values()) {
            if (format == UNDEFINED) continue;
            arrList.add(format.toString());
        }
        return arrList.toArray(new String[arrList.size()]);
    }

    public String toExtension() {
        return "." + this.name().toLowerCase();
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

