/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.geom.Point2D;

public class FreeFlightCamera
extends Camera
implements IUpdateable {
    private static final double DEFAULT_SCROLL_PIXELS_PER_SECOND = 400.0;
    private static final double DEFAULT_SCROLL_PADDING = 20.0;
    private double velocity;
    private double scrollPadding;

    public FreeFlightCamera() {
        this(0.0, 0.0);
    }

    public FreeFlightCamera(double x, double y) {
        this(new Point2D.Double(x, y));
    }

    public FreeFlightCamera(Point2D focus) {
        this.setFocus(focus);
        this.velocity = 400.0;
        this.scrollPadding = 20.0;
        this.setClampToMap(true);
        Game.loop().attach(this);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getScrollPadding() {
        return this.scrollPadding;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public void setScrollPadding(double scrollPadding) {
        this.scrollPadding = scrollPadding;
    }

    @Override
    public void update() {
        this.handleFreeFlightCamera();
    }

    private void handleFreeFlightCamera() {
        if (Game.world().environment() == null || Game.world().environment().getMap() == null) {
            return;
        }
        Point2D mouseLocation = Input.mouse().getLocation();
        double scrollSpeed = this.getVelocity() / (double)Game.loop().getUpdateRate() * (double)Game.config().input().getMouseSensitivity();
        double x = this.getFocus().getX();
        double y = this.getFocus().getY();
        double deltaX = 0.0;
        if (mouseLocation.getX() < this.getScrollPadding()) {
            deltaX -= scrollSpeed;
        } else if (Game.window().getResolution().getWidth() - mouseLocation.getX() < this.getScrollPadding()) {
            deltaX += scrollSpeed;
        }
        double deltaY = 0.0;
        if (mouseLocation.getY() < this.getScrollPadding()) {
            deltaY -= scrollSpeed;
        } else if (Game.window().getResolution().getHeight() - mouseLocation.getY() < this.getScrollPadding()) {
            deltaY += scrollSpeed;
        }
        this.setFocus(new Point2D.Double(x += deltaX, y += deltaY));
    }
}

